/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.particle.plasmaball;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import voltaic.api.codec.StreamCodec;
import voltaic.prefab.utilities.CodecUtils;
import voltaic.registers.VoltaicParticles;

public class ParticleOptionPlasmaBall
extends ParticleType<ParticleOptionPlasmaBall>
implements ParticleOptions {
    public float scale;
    public float gravity;
    public int maxAge;
    public int r;
    public int g;
    public int b;
    public int a;
    public static final Codec<ParticleOptionPlasmaBall> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("scale").forGetter(instance0 -> Float.valueOf(instance0.scale)), (App)Codec.FLOAT.fieldOf("gravity").forGetter(instance0 -> Float.valueOf(instance0.gravity)), (App)Codec.INT.fieldOf("maxage").forGetter(instance0 -> instance0.maxAge), (App)Codec.INT.fieldOf("r").forGetter(instance0 -> instance0.r), (App)Codec.INT.fieldOf("g").forGetter(instance0 -> instance0.g), (App)Codec.INT.fieldOf("b").forGetter(instance0 -> instance0.b), (App)Codec.INT.fieldOf("a").forGetter(instance0 -> instance0.a)).apply((Applicative)instance, (scale, gravity, age, r, g, b, a) -> new ParticleOptionPlasmaBall().setParameters(scale.floatValue(), gravity.floatValue(), (int)age, (int)r, (int)g, (int)b, (int)a)));
    public static final StreamCodec<FriendlyByteBuf, ParticleOptionPlasmaBall> STREAM_CODEC = CodecUtils.composite(StreamCodec.FLOAT, instance0 -> Float.valueOf(instance0.scale), StreamCodec.FLOAT, instance0 -> Float.valueOf(instance0.gravity), StreamCodec.INT, instance0 -> instance0.maxAge, StreamCodec.INT, instance0 -> instance0.r, StreamCodec.INT, instance0 -> instance0.g, StreamCodec.INT, instance0 -> instance0.b, StreamCodec.INT, instance0 -> instance0.a, (scale, gravity, age, r, g, b, a) -> new ParticleOptionPlasmaBall().setParameters(scale.floatValue(), gravity.floatValue(), (int)age, (int)r, (int)g, (int)b, (int)a));
    public static final ParticleOptions.Deserializer<ParticleOptionPlasmaBall> DESERIALIZER = new ParticleOptions.Deserializer<ParticleOptionPlasmaBall>(){

        public ParticleOptionPlasmaBall fromCommand(ParticleType<ParticleOptionPlasmaBall> type, StringReader reader) throws CommandSyntaxException {
            ParticleOptionPlasmaBall particle = new ParticleOptionPlasmaBall();
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            float gravity = reader.readFloat();
            reader.expect(' ');
            int maxAge = reader.readInt();
            reader.expect(' ');
            int r = reader.readInt();
            reader.expect(' ');
            int g = reader.readInt();
            reader.expect(' ');
            int b = reader.readInt();
            reader.expect(' ');
            int a = reader.readInt();
            return particle.setParameters(scale, gravity, maxAge, r, g, b, a);
        }

        public ParticleOptionPlasmaBall fromNetwork(ParticleType<ParticleOptionPlasmaBall> type, FriendlyByteBuf buffer) {
            return STREAM_CODEC.decode(buffer);
        }
    };

    public ParticleOptionPlasmaBall() {
        super(false, DESERIALIZER);
    }

    public ParticleOptionPlasmaBall setParameters(float scale, float gravity, int maxAge, int r, int g, int b, int a) {
        this.scale = scale;
        this.gravity = gravity;
        this.maxAge = maxAge;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return this;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)VoltaicParticles.PARTICLE_PLASMA_BALL.get();
    }

    public String toString() {
        return BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()).toString() + ", scale: " + this.scale + ", gravity: " + this.gravity + ", maxage: " + this.maxAge + ", r: " + this.r + ", g: " + this.g + ", b: " + this.b + ", a: " + this.a;
    }

    public Codec<ParticleOptionPlasmaBall> m_7652_() {
        return CODEC;
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        STREAM_CODEC.encode(pBuffer, this);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()).toString() + ", scale: " + this.scale + ", gravity: " + this.gravity + ", maxAge: " + this.maxAge + ", r: " + this.r + ", g: " + this.g + ", b: " + this.b + ", a: " + this.a;
    }
}

