/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentBlock;
import voltaic.api.multiblock.subnodebased.parent.IMultiblockParentTile;
import voltaic.api.tile.IMachine;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.block.GenericMachineBlock;

public class BlockMachine
extends GenericMachineBlock
implements IMultiblockParentBlock {
    protected final IMachine machine;

    public BlockMachine(IMachine machine) {
        super(machine.getBlockEntitySupplier(), machine.getVoxelShapeProvider());
        this.machine = machine;
        if (machine.usesLit()) {
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean m_7420_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        if (this.machine.propegatesLightDown()) {
            return true;
        }
        return super.m_7420_(pState, pLevel, pPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (this.machine.isMultiblock()) {
            return this.isValidMultiblockPlacement(state, worldIn, pos, this.machine.getSubnodes().getSubnodes(state.m_61138_((Property)VoltaicBlockStates.FACING) ? (Direction)state.m_61143_((Property)VoltaicBlockStates.FACING) : Direction.NORTH));
        }
        return super.m_7898_(state, worldIn, pos);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return this.machine.getRenderShape();
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        if (this.machine.getLitBrightness() > 0 && state.m_61138_((Property)VoltaicBlockStates.LIT) && ((Boolean)state.m_61143_((Property)VoltaicBlockStates.LIT)).booleanValue()) {
            return this.machine.getLitBrightness();
        }
        return super.getLightEmission(state, world, pos);
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        BlockEntity tile = worldIn.m_7702_(pos);
        if (this.hasMultiBlock() && tile instanceof IMultiblockParentTile) {
            IMultiblockParentTile multi = (IMultiblockParentTile)tile;
            multi.onNodePlaced(worldIn, pos, state, placer, stack);
        }
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IMultiblockParentTile multi;
        BlockEntity tile = worldIn.m_7702_(pos);
        if ((state.m_60734_() != newState.m_60734_() || state.m_61143_((Property)VoltaicBlockStates.FACING) == newState.m_61143_((Property)VoltaicBlockStates.FACING)) && tile instanceof IMultiblockParentTile) {
            multi = (IMultiblockParentTile)tile;
            multi.onNodeReplaced(worldIn, pos, true);
        }
        if (newState.m_60795_() && tile instanceof IMultiblockParentTile) {
            multi = (IMultiblockParentTile)tile;
            multi.onNodeReplaced(worldIn, pos, false);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public boolean hasMultiBlock() {
        return this.machine.isMultiblock();
    }

    @Override
    public boolean isIPlayerStorable() {
        return this.machine.isPlayerStorable();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        BlockEntity tile = level.m_7702_(pos);
        if (tile != null) {
            tile.m_187476_(stack);
        }
        return stack;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)VoltaicBlockStates.LIT, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VoltaicBlockStates.LIT});
    }
}

