/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.item;

import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import voltaic.common.item.ItemVoltaic;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.utilities.NBTUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ItemUpgrade
extends ItemVoltaic {
    public final SubtypeItemUpgrade subtype;
    private static final DecimalFormat FORMATTER = new DecimalFormat("0.00");

    public ItemUpgrade(Item.Properties properties, SubtypeItemUpgrade subtype, Supplier<CreativeModeTab> creativeTab) {
        super(properties.m_41487_(subtype.maxSize), creativeTab);
        this.subtype = subtype;
    }

    public void m_7373_(ItemStack stack, Level context, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, context, tooltip, flagIn);
        if (this.subtype == SubtypeItemUpgrade.advancedcapacity || this.subtype == SubtypeItemUpgrade.basiccapacity) {
            double capacityMultiplier = this.subtype == SubtypeItemUpgrade.advancedcapacity ? 2.25 : 1.5;
            double voltageMultiplier = this.subtype == SubtypeItemUpgrade.advancedcapacity ? 4.0 : 2.0;
            tooltip.add((Component)VoltaicTextUtils.tooltip("info.upgradecapacity", Component.m_237113_((String)(capacityMultiplier + "x")).m_130940_(ChatFormatting.GREEN)).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)VoltaicTextUtils.tooltip("info.upgradeenergytransfer", Component.m_237113_((String)(capacityMultiplier + "x")).m_130940_(ChatFormatting.GREEN)).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)VoltaicTextUtils.tooltip("info.upgradevoltage", Component.m_237113_((String)(voltageMultiplier + "x")).m_130940_(ChatFormatting.GREEN)).m_130940_(ChatFormatting.GRAY));
        }
        if (this.subtype == SubtypeItemUpgrade.advancedspeed || this.subtype == SubtypeItemUpgrade.basicspeed) {
            double speedMultiplier = this.subtype == SubtypeItemUpgrade.advancedspeed ? 2.25 : 1.5;
            tooltip.add((Component)VoltaicTextUtils.tooltip("info.upgradespeed", Component.m_237113_((String)(speedMultiplier + "x")).m_130940_(ChatFormatting.GREEN)).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)VoltaicTextUtils.tooltip("info.upgradeenergyusage", Component.m_237113_((String)(speedMultiplier + "x")).m_130940_(ChatFormatting.RED)).m_130940_(ChatFormatting.GRAY));
        }
        if (this.subtype == SubtypeItemUpgrade.itemoutput || this.subtype == SubtypeItemUpgrade.iteminput) {
            List<Direction> dirs;
            if (this.subtype == SubtypeItemUpgrade.itemoutput) {
                tooltip.add((Component)VoltaicTextUtils.tooltip("info.itemoutputupgrade", new Object[0]).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)VoltaicTextUtils.tooltip("info.iteminputupgrade", new Object[0]).m_130940_(ChatFormatting.GRAY));
            }
            if (stack.m_41784_().m_128471_("smart")) {
                tooltip.add((Component)VoltaicTextUtils.tooltip("info.insmartmode", new Object[0]).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
            if (!(dirs = NBTUtils.readDirectionList(stack)).isEmpty()) {
                tooltip.add((Component)VoltaicTextUtils.tooltip("info.dirlist", new Object[0]).m_130940_(ChatFormatting.BLUE));
                for (int i = 0; i < dirs.size(); ++i) {
                    Direction dir = dirs.get(i);
                    tooltip.add((Component)Component.m_237113_((String)(i + 1 + ". " + StringUtils.capitalize((String)dir.m_122433_()))).m_130940_(ChatFormatting.BLUE));
                }
                tooltip.add((Component)VoltaicTextUtils.tooltip("info.cleardirs", new Object[0]).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)VoltaicTextUtils.tooltip("info.nodirs", new Object[0]).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)VoltaicTextUtils.tooltip("info.togglesmart", new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
        if (this.subtype == SubtypeItemUpgrade.experience) {
            double storedXp = stack.m_41784_().m_128459_("xp");
            tooltip.add((Component)VoltaicTextUtils.tooltip("info.xpstored", Component.m_237113_((String)FORMATTER.format(storedXp)).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)VoltaicTextUtils.tooltip("info.xpusage", new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
        if (this.subtype == SubtypeItemUpgrade.range) {
            tooltip.add((Component)VoltaicTextUtils.tooltip("info.range", new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            ItemStack handStack = player.m_21120_(hand);
            SubtypeItemUpgrade localSubtype = ((ItemUpgrade)handStack.m_41720_()).subtype;
            if (localSubtype == SubtypeItemUpgrade.iteminput || localSubtype == SubtypeItemUpgrade.itemoutput) {
                if (player.m_6144_()) {
                    Vec3 look = player.m_20154_();
                    Direction lookingDir = Direction.m_122366_((double)look.f_82479_, (double)look.f_82480_, (double)look.f_82481_);
                    List<Direction> dirs = NBTUtils.readDirectionList(handStack);
                    dirs.add(lookingDir);
                    NBTUtils.clearDirectionList(handStack);
                    NBTUtils.writeDirectionList(dirs, handStack);
                } else {
                    CompoundTag tag;
                    tag.m_128379_("smart", !(tag = handStack.m_41784_()).m_128471_("smart"));
                }
                return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
            }
            if (localSubtype == SubtypeItemUpgrade.experience) {
                CompoundTag tag = handStack.m_41784_();
                double storedXp = tag.m_128459_("xp");
                int takenXp = (int)storedXp;
                Vec3 playerPos = new Vec3((double)player.m_20183_().m_123341_(), (double)player.m_20183_().m_123342_(), (double)player.m_20183_().m_123343_());
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)world), (Vec3)playerPos, (int)takenXp);
                tag.m_128347_("xp", storedXp - (double)takenXp);
                return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
            }
        }
        return super.m_7203_(world, player, hand);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        SubtypeItemUpgrade subtype;
        if (!(entity.m_9236_().f_46443_ || !entity.m_6144_() || entity.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && entity.m_21120_(InteractionHand.OFF_HAND).m_41619_() || (subtype = ((ItemUpgrade)stack.m_41720_()).subtype) != SubtypeItemUpgrade.iteminput && subtype != SubtypeItemUpgrade.itemoutput)) {
            NBTUtils.clearDirectionList(stack);
        }
        return super.onEntitySwing(stack, entity);
    }

    public boolean m_5812_(ItemStack stack) {
        SubtypeItemUpgrade subtype = ((ItemUpgrade)stack.m_41720_()).subtype;
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128471_("smart");
        }
        return subtype == SubtypeItemUpgrade.fortune || subtype == SubtypeItemUpgrade.unbreaking || subtype == SubtypeItemUpgrade.silktouch;
    }
}

