/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.network.utils;

import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;

public class FluidUtilities {
    public static boolean isFluidReceiver(BlockEntity acceptor, Direction dir) {
        return acceptor != null && acceptor.getCapability(ForgeCapabilities.FLUID_HANDLER, dir).isPresent();
    }

    public static int receiveFluid(BlockEntity acceptor, Direction direction, FluidStack perReceiver, boolean debug) {
        if (acceptor == null) {
            return 0;
        }
        IFluidHandler handler = (IFluidHandler)acceptor.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).orElse((Object)CapabilityUtils.EMPTY_FLUID);
        if (handler == CapabilityUtils.EMPTY_FLUID) {
            return 0;
        }
        for (int i = 0; i < handler.getTanks(); ++i) {
            if (!handler.isFluidValid(i, perReceiver)) continue;
            return handler.fill(perReceiver, debug ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        }
        return 0;
    }

    public static boolean canInputFluid(BlockEntity acceptor, Direction direction) {
        return FluidUtilities.isFluidReceiver(acceptor, direction);
    }

    public static void outputToPipe(GenericTile tile, FluidTank[] tanks, Direction ... outputDirections) {
        Direction facing = tile.getFacing();
        for (Direction relative : outputDirections) {
            IFluidHandler handler;
            Direction direction = BlockEntityUtils.getRelativeSide(facing, relative);
            BlockEntity faceTile = tile.m_58904_().m_7702_(tile.m_58899_().m_121945_(direction));
            if (faceTile == null || (handler = (IFluidHandler)faceTile.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_FLUID)) == CapabilityUtils.EMPTY_FLUID) continue;
            for (FluidTank fluidTank : tanks) {
                FluidStack tankFluid = fluidTank.getFluid();
                int amtAccepted = handler.fill(tankFluid, IFluidHandler.FluidAction.EXECUTE);
                FluidStack taken = new FluidStack(tankFluid.getFluid(), amtAccepted);
                fluidTank.drain(taken, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public static void drainItem(GenericTile tile, FluidTank[] tanks) {
        ComponentInventory inv = (ComponentInventory)tile.getComponent(IComponentType.Inventory);
        int bucketIndex = inv.getInputBucketStartIndex();
        int size = inv.getInputBucketContents().size();
        if (tanks.length < size) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            FluidStack containerFluid;
            IFluidHandlerItem handler;
            int index = bucketIndex + i;
            FluidTank tank = tanks[i];
            ItemStack stack = inv.m_8020_(index);
            int room = tank.getSpace();
            if (stack.m_41619_() || room <= 0 || (handler = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM)) == CapabilityUtils.EMPTY_FLUID_ITEM || (containerFluid = handler.drain(room, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || !tank.isFluidValid(containerFluid)) continue;
            int accepted = tank.fill(containerFluid, IFluidHandler.FluidAction.EXECUTE);
            handler.drain(accepted, IFluidHandler.FluidAction.EXECUTE);
            inv.m_6836_(index, handler.getContainer());
        }
    }

    public static void fillItem(GenericTile tile, FluidTank[] tanks) {
        ComponentInventory inv = (ComponentInventory)tile.getComponent(IComponentType.Inventory);
        int bucketIndex = inv.getOutputBucketStartIndex();
        int size = inv.getOutputBucketContents().size();
        if (tanks.length < size) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            IFluidHandlerItem handler;
            int index = bucketIndex + i;
            ItemStack stack = inv.m_8020_(index);
            FluidTank tank = tanks[i];
            if (stack.m_41619_() || tank.isEmpty() || (handler = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM)) == CapabilityUtils.EMPTY_FLUID_ITEM) continue;
            FluidStack fluid = tank.getFluid();
            int taken = handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            tank.drain(taken, IFluidHandler.FluidAction.EXECUTE);
            inv.m_6836_(index, handler.getContainer());
        }
    }

    @Deprecated(since="don't set a filter if you want to allow for all fluids")
    public static Fluid[] getAllRegistryFluids() {
        return (Fluid[])BuiltInRegistries.f_257020_.m_123024_().toArray(Fluid[]::new);
    }
}

