/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.packet.types.server;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import voltaic.api.codec.StreamCodec;
import voltaic.common.packet.types.server.ServerBarrierMethods;

public class PacketSendUpdatePropertiesServer {
    public static final StreamCodec<FriendlyByteBuf, PacketSendUpdatePropertiesServer> CODEC = new StreamCodec<FriendlyByteBuf, PacketSendUpdatePropertiesServer>(){

        @Override
        public void encode(FriendlyByteBuf buf, PacketSendUpdatePropertiesServer packet) {
            buf.m_130079_(packet.data);
            buf.writeInt(packet.index);
            buf.m_130064_(packet.tilePos);
        }

        @Override
        public PacketSendUpdatePropertiesServer decode(FriendlyByteBuf buf) {
            return new PacketSendUpdatePropertiesServer(buf.m_130260_(), buf.readInt(), buf.m_130135_());
        }
    };
    private final BlockPos tilePos;
    private int index;
    private CompoundTag data;

    public PacketSendUpdatePropertiesServer(CompoundTag data, int index, BlockPos tilePos) {
        this.tilePos = tilePos;
        this.index = index;
        this.data = data;
    }

    public static void handle(PacketSendUpdatePropertiesServer message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerLevel world = ((NetworkEvent.Context)context.get()).getSender().m_284548_();
            if (world != null) {
                ServerBarrierMethods.handleSendUpdatePropertiesServer((Level)world, message.tilePos, message.data, message.index);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSendUpdatePropertiesServer message, FriendlyByteBuf buf) {
        CODEC.encode(buf, message);
    }

    public static PacketSendUpdatePropertiesServer decode(FriendlyByteBuf buf) {
        return CODEC.decode(buf);
    }
}

