/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import voltaic.api.codec.StreamCodec;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasStack;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.GasIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.registers.VoltaicRegistries;

public abstract class VoltaicRecipeSerializer<T extends VoltaicRecipe>
implements RecipeSerializer<T> {
    private final StreamCodec<FriendlyByteBuf, T> streamCodec;
    public static final String COUNT = "count";
    public static final String ITEM_INPUTS = "iteminputs";
    public static final String FLUID_INPUTS = "fluidinputs";
    public static final String GAS_INPUTS = "gasinputs";
    public static final String ITEM_BIPRODUCTS = "itembi";
    public static final String FLUID_BIPRODUCTS = "fluidbi";
    public static final String GAS_BIPRODUCTS = "gasbi";
    public static final String OUTPUT = "output";
    public static final String EXPERIENCE = "experience";
    public static final String TICKS = "ticks";
    public static final String USAGE_PER_TICK = "usagepertick";
    public static final String GROUP = "group";

    public VoltaicRecipeSerializer(StreamCodec<FriendlyByteBuf, T> streamCodec) {
        this.streamCodec = streamCodec;
    }

    @Nullable
    public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        return (T)((VoltaicRecipe)this.streamCodec.decode(pBuffer));
    }

    public void toNetwork(FriendlyByteBuf pBuffer, T pRecipe) {
        this.streamCodec.encode(pBuffer, pRecipe);
    }

    public static List<CountableIngredient> getItemIngredients(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(ITEM_INPUTS)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": There are no Item Inputs!");
        }
        JsonObject itemInputs = GsonHelper.m_13930_((JsonObject)json, (String)ITEM_INPUTS);
        if (!itemInputs.has(COUNT)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include a count field");
        }
        int count = itemInputs.get(COUNT).getAsInt();
        ArrayList<CountableIngredient> itemIngredients = new ArrayList<CountableIngredient>();
        for (int i = 0; i < count; ++i) {
            if (!itemInputs.has("" + i)) {
                throw new UnsupportedOperationException(recipeId.toString() + ": The count field does not match the input count");
            }
            CountableIngredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)itemInputs.get("" + i)).result().ifPresent(pair -> itemIngredients.add((CountableIngredient)((Object)((Object)pair.getFirst()))));
        }
        return itemIngredients;
    }

    public static List<FluidIngredient> getFluidIngredients(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(FLUID_INPUTS)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": There are no Fluid Inputs!");
        }
        JsonObject fluidInputs = GsonHelper.m_13930_((JsonObject)json, (String)FLUID_INPUTS);
        if (!fluidInputs.has(COUNT)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include a count field");
        }
        int count = fluidInputs.get(COUNT).getAsInt();
        ArrayList<FluidIngredient> fluidIngredients = new ArrayList<FluidIngredient>();
        for (int i = 0; i < count; ++i) {
            if (!fluidInputs.has("" + i)) {
                throw new UnsupportedOperationException(recipeId.toString() + ": The count field does not match the input count");
            }
            FluidIngredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)fluidInputs.get("" + i).getAsJsonObject()).result().ifPresent(pair -> fluidIngredients.add((FluidIngredient)((Object)((Object)pair.getFirst()))));
        }
        return fluidIngredients;
    }

    public static List<GasIngredient> getGasIngredients(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(GAS_INPUTS)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": There are no Gas Inputs!");
        }
        JsonObject fluidInputs = GsonHelper.m_13930_((JsonObject)json, (String)GAS_INPUTS);
        if (!fluidInputs.has(COUNT)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include a count field");
        }
        int count = fluidInputs.get(COUNT).getAsInt();
        ArrayList<GasIngredient> gasIngredients = new ArrayList<GasIngredient>();
        for (int i = 0; i < count; ++i) {
            if (!fluidInputs.has("" + i)) {
                throw new UnsupportedOperationException(recipeId.toString() + ": The count field does not match the input count");
            }
            GasIngredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)fluidInputs.get("" + i).getAsJsonObject()).result().ifPresent(pair -> gasIngredients.add((GasIngredient)((Object)((Object)pair.getFirst()))));
        }
        return gasIngredients;
    }

    @Nullable
    public static List<ProbableItem> getItemBiproducts(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(ITEM_BIPRODUCTS)) {
            return Collections.emptyList();
        }
        JsonObject itemBiproducts = GsonHelper.m_13930_((JsonObject)json, (String)ITEM_BIPRODUCTS);
        if (!itemBiproducts.has(COUNT)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include a count field");
        }
        int count = itemBiproducts.get(COUNT).getAsInt();
        ArrayList<ProbableItem> items = new ArrayList<ProbableItem>();
        for (int i = 0; i < count; ++i) {
            if (!itemBiproducts.has("" + i)) {
                throw new UnsupportedOperationException(recipeId.toString() + ": The count field does not match the input count");
            }
            ProbableItem.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)itemBiproducts.get("" + i).getAsJsonObject()).result().ifPresent(pair -> items.add((ProbableItem)pair.getFirst()));
        }
        return items;
    }

    @Nullable
    public static List<ProbableFluid> getFluidBiproducts(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(FLUID_BIPRODUCTS)) {
            return Collections.emptyList();
        }
        JsonObject fluidBiproducts = GsonHelper.m_13930_((JsonObject)json, (String)FLUID_BIPRODUCTS);
        if (!fluidBiproducts.has(COUNT)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include a count field");
        }
        int count = fluidBiproducts.get(COUNT).getAsInt();
        ArrayList<ProbableFluid> gases = new ArrayList<ProbableFluid>();
        for (int i = 0; i < count; ++i) {
            if (!fluidBiproducts.has("" + i)) {
                throw new UnsupportedOperationException(recipeId.toString() + ": The count field does not match the input count");
            }
            ProbableFluid.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)fluidBiproducts.get("" + i).getAsJsonObject()).result().ifPresent(pair -> gases.add((ProbableFluid)pair.getFirst()));
        }
        return gases;
    }

    public static List<ProbableGas> getGasBiproducts(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(GAS_BIPRODUCTS)) {
            return Collections.emptyList();
        }
        JsonObject gasBiproducts = GsonHelper.m_13930_((JsonObject)json, (String)GAS_BIPRODUCTS);
        if (!gasBiproducts.has(COUNT)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include a count field");
        }
        int count = gasBiproducts.get(COUNT).getAsInt();
        ArrayList<ProbableGas> fluids = new ArrayList<ProbableGas>();
        for (int i = 0; i < count; ++i) {
            if (!gasBiproducts.has("" + i)) {
                throw new UnsupportedOperationException(recipeId.toString() + ": The count field does not match the input count");
            }
            ProbableGas.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)gasBiproducts.get("" + i).getAsJsonObject()).result().ifPresent(pair -> fluids.add((ProbableGas)pair.getFirst()));
        }
        return fluids;
    }

    public static ItemStack getItemOutput(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(OUTPUT)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include an Item output!");
        }
        return CraftingHelper.getItemStack((JsonObject)json.get(OUTPUT).getAsJsonObject(), (boolean)false);
    }

    public static FluidStack getFluidOutput(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(OUTPUT)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include a Fluid output!");
        }
        JsonObject fluid = json.get(OUTPUT).getAsJsonObject();
        ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)fluid, (String)"fluid"));
        int amount = GsonHelper.m_13927_((JsonObject)fluid, (String)"amount");
        return new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation), amount);
    }

    public static GasStack getGasOutput(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(OUTPUT)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include a Gas output!");
        }
        JsonObject gas = json.get(OUTPUT).getAsJsonObject();
        ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)gas, (String)"gas"));
        int amount = GsonHelper.m_13927_((JsonObject)gas, (String)"amount");
        int temperature = GsonHelper.m_13927_((JsonObject)gas, (String)"temp");
        int pressure = GsonHelper.m_13927_((JsonObject)gas, (String)"pressure");
        return new GasStack((Gas)VoltaicRegistries.gasRegistry().getValue(resourceLocation), amount, temperature, pressure);
    }

    public static double getExperience(JsonObject json) {
        return json.has(EXPERIENCE) ? json.get(EXPERIENCE).getAsDouble() : 0.0;
    }

    public static int getTicks(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(TICKS)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include an operating tick time!");
        }
        return json.get(TICKS).getAsInt();
    }

    public static double getUsagePerTick(ResourceLocation recipeId, JsonObject json) {
        if (!json.has(USAGE_PER_TICK)) {
            throw new UnsupportedOperationException(recipeId.toString() + ": You must include a usage per tick!");
        }
        return json.get(USAGE_PER_TICK).getAsDouble();
    }
}

