/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.categories.fluid2item;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import voltaic.api.codec.StreamCodec;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.VoltaicRecipeSerializer;
import voltaic.common.recipe.categories.fluid2item.Fluid2ItemRecipe;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.utilities.CodecUtils;

public class Fluid2ItemRecipeSerializer<T extends Fluid2ItemRecipe>
extends VoltaicRecipeSerializer<T> {
    private final Fluid2ItemRecipe.Factory<T> factory;

    public Fluid2ItemRecipeSerializer(Fluid2ItemRecipe.Factory<T> factory) {
        super(CodecUtils.composite(StreamCodec.RESOURCE_LOCATION, VoltaicRecipe::m_6423_, FluidIngredient.LIST_STREAM_CODEC, Fluid2ItemRecipe::getFluidIngredients, StreamCodec.ITEM_STACK, Fluid2ItemRecipe::getItemRecipeOutput, StreamCodec.DOUBLE, VoltaicRecipe::getXp, StreamCodec.INT, VoltaicRecipe::getTicks, StreamCodec.DOUBLE, VoltaicRecipe::getUsagePerTick, ProbableItem.LIST_STREAM_CODEC, VoltaicRecipe::getItemBiproducts, ProbableFluid.LIST_STREAM_CODEC, VoltaicRecipe::getFluidBiproducts, ProbableGas.LIST_STREAM_CODEC, VoltaicRecipe::getGasBiproducts, factory::create));
        this.factory = factory;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject recipeJson) {
        List<FluidIngredient> inputs = Fluid2ItemRecipeSerializer.getFluidIngredients(recipeId, recipeJson);
        ItemStack output = Fluid2ItemRecipeSerializer.getItemOutput(recipeId, recipeJson);
        double experience = Fluid2ItemRecipeSerializer.getExperience(recipeJson);
        int ticks = Fluid2ItemRecipeSerializer.getTicks(recipeId, recipeJson);
        double usagePerTick = Fluid2ItemRecipeSerializer.getUsagePerTick(recipeId, recipeJson);
        List<ProbableItem> itemBi = Fluid2ItemRecipeSerializer.getItemBiproducts(recipeId, recipeJson);
        List<ProbableFluid> fluidBi = Fluid2ItemRecipeSerializer.getFluidBiproducts(recipeId, recipeJson);
        List<ProbableGas> gasBi = Fluid2ItemRecipeSerializer.getGasBiproducts(recipeId, recipeJson);
        return this.factory.create(recipeId, inputs, output, experience, ticks, usagePerTick, itemBi, fluidBi, gasBi);
    }
}

