/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.categories.fluiditem2item;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import voltaic.api.codec.StreamCodec;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.VoltaicRecipeSerializer;
import voltaic.common.recipe.categories.fluiditem2item.FluidItem2ItemRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.utilities.CodecUtils;

public class FluidItem2ItemRecipeSerializer<T extends FluidItem2ItemRecipe>
extends VoltaicRecipeSerializer<T> {
    private final FluidItem2ItemRecipe.Factory<T> factory;

    public FluidItem2ItemRecipeSerializer(FluidItem2ItemRecipe.Factory<T> factory) {
        super(CodecUtils.composite(StreamCodec.RESOURCE_LOCATION, VoltaicRecipe::m_6423_, CountableIngredient.LIST_STREAM_CODEC, FluidItem2ItemRecipe::getCountedIngredients, FluidIngredient.LIST_STREAM_CODEC, FluidItem2ItemRecipe::getFluidIngredients, StreamCodec.ITEM_STACK, FluidItem2ItemRecipe::getItemRecipeOutput, StreamCodec.DOUBLE, VoltaicRecipe::getXp, StreamCodec.INT, VoltaicRecipe::getTicks, StreamCodec.DOUBLE, VoltaicRecipe::getUsagePerTick, ProbableItem.LIST_STREAM_CODEC, VoltaicRecipe::getItemBiproducts, ProbableFluid.LIST_STREAM_CODEC, VoltaicRecipe::getFluidBiproducts, ProbableGas.LIST_STREAM_CODEC, VoltaicRecipe::getGasBiproducts, factory::create));
        this.factory = factory;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject recipeJson) {
        List<CountableIngredient> inputs = FluidItem2ItemRecipeSerializer.getItemIngredients(recipeId, recipeJson);
        List<FluidIngredient> fluidInputs = FluidItem2ItemRecipeSerializer.getFluidIngredients(recipeId, recipeJson);
        ItemStack output = FluidItem2ItemRecipeSerializer.getItemOutput(recipeId, recipeJson);
        double experience = FluidItem2ItemRecipeSerializer.getExperience(recipeJson);
        int ticks = FluidItem2ItemRecipeSerializer.getTicks(recipeId, recipeJson);
        double usagePerTick = FluidItem2ItemRecipeSerializer.getUsagePerTick(recipeId, recipeJson);
        List<ProbableItem> itemBi = FluidItem2ItemRecipeSerializer.getItemBiproducts(recipeId, recipeJson);
        List<ProbableFluid> fluidBi = FluidItem2ItemRecipeSerializer.getFluidBiproducts(recipeId, recipeJson);
        List<ProbableGas> gasBi = FluidItem2ItemRecipeSerializer.getGasBiproducts(recipeId, recipeJson);
        return this.factory.create(recipeId, inputs, fluidInputs, output, experience, ticks, usagePerTick, itemBi, fluidBi, gasBi);
    }
}

