/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.recipeutils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fluids.FluidStack;
import voltaic.Voltaic;
import voltaic.api.codec.StreamCodec;

public class ProbableFluid {
    public static final Codec<ProbableFluid> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf("fluid").forGetter(instance0 -> instance0.fluid.getFluid()), (App)Codec.INT.fieldOf("amount").forGetter(instance0 -> instance0.fluid.getAmount()), (App)Codec.DOUBLE.fieldOf("chance").forGetter(instance0 -> instance0.chance)).apply((Applicative)instance, (fluid, amt, chance) -> new ProbableFluid(new FluidStack(fluid, amt.intValue()), (double)chance)));
    public static final Codec<List<ProbableFluid>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<FriendlyByteBuf, ProbableFluid> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ProbableFluid>(){

        @Override
        public ProbableFluid decode(FriendlyByteBuf buf) {
            return new ProbableFluid(StreamCodec.FLUID_STACK.decode(buf), buf.readDouble());
        }

        @Override
        public void encode(FriendlyByteBuf buf, ProbableFluid fluid) {
            StreamCodec.FLUID_STACK.encode(buf, fluid.fluid);
            buf.writeDouble(fluid.chance);
        }
    };
    public static final StreamCodec<FriendlyByteBuf, List<ProbableFluid>> LIST_STREAM_CODEC = new StreamCodec<FriendlyByteBuf, List<ProbableFluid>>(){

        @Override
        public void encode(FriendlyByteBuf buf, List<ProbableFluid> probable) {
            buf.writeInt(probable.size());
            for (ProbableFluid fluid : probable) {
                STREAM_CODEC.encode(buf, fluid);
            }
        }

        @Override
        public List<ProbableFluid> decode(FriendlyByteBuf buf) {
            int count = buf.readInt();
            ArrayList<ProbableFluid> fluids = new ArrayList<ProbableFluid>();
            for (int i = 0; i < count; ++i) {
                fluids.add(STREAM_CODEC.decode(buf));
            }
            return fluids;
        }
    };
    public static final List<ProbableFluid> NONE = new ArrayList<ProbableFluid>();
    private FluidStack fluid;
    private double chance;

    public ProbableFluid(FluidStack stack, double chance) {
        this.fluid = stack;
        this.setChance(chance);
    }

    public FluidStack getFullStack() {
        return this.fluid;
    }

    private void setChance(double chance) {
        this.chance = chance > 1.0 ? 1.0 : (chance < 0.0 ? 0.0 : chance);
    }

    public double getChance() {
        return this.chance;
    }

    public FluidStack roll() {
        double random = Voltaic.RANDOM.nextDouble();
        if (random > 1.0 - this.chance) {
            double amount = this.chance >= 1.0 ? (double)this.fluid.getAmount() : (double)this.fluid.getAmount() * random;
            int fluidAmount = (int)Math.ceil(amount);
            return new FluidStack(this.fluid.getFluid(), fluidAmount);
        }
        return FluidStack.EMPTY;
    }
}

