/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.recipeutils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import voltaic.Voltaic;
import voltaic.api.codec.StreamCodec;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasStack;
import voltaic.registers.VoltaicRegistries;

public class ProbableGas {
    public static final Codec<ProbableGas> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VoltaicRegistries.gasRegistry().getCodec().fieldOf("gas").forGetter(instance0 -> instance0.gas.getGas()), (App)Codec.INT.fieldOf("amount").forGetter(instance0 -> instance0.gas.getAmount()), (App)Codec.INT.fieldOf("temp").forGetter(instance0 -> instance0.gas.getTemperature()), (App)Codec.INT.fieldOf("pressure").forGetter(instance0 -> instance0.gas.getPressure()), (App)Codec.DOUBLE.fieldOf("chance").forGetter(instance0 -> instance0.chance)).apply((Applicative)instance, (gas, amt, temp, pres, chance) -> new ProbableGas(new GasStack((Gas)gas, (int)amt, (int)temp, (int)pres), (double)chance)));
    public static final Codec<List<ProbableGas>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<FriendlyByteBuf, ProbableGas> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ProbableGas>(){

        @Override
        public void encode(FriendlyByteBuf buf, ProbableGas gas) {
            GasStack.STREAM_CODEC.encode(buf, gas.gas);
            buf.writeDouble(gas.chance);
        }

        @Override
        public ProbableGas decode(FriendlyByteBuf buf) {
            return new ProbableGas(GasStack.STREAM_CODEC.decode(buf), buf.readDouble());
        }
    };
    public static final StreamCodec<FriendlyByteBuf, List<ProbableGas>> LIST_STREAM_CODEC = new StreamCodec<FriendlyByteBuf, List<ProbableGas>>(){

        @Override
        public List<ProbableGas> decode(FriendlyByteBuf buf) {
            int count = buf.readInt();
            ArrayList<ProbableGas> fluids = new ArrayList<ProbableGas>();
            for (int i = 0; i < count; ++i) {
                fluids.add(STREAM_CODEC.decode(buf));
            }
            return fluids;
        }

        @Override
        public void encode(FriendlyByteBuf buf, List<ProbableGas> probable) {
            buf.writeInt(probable.size());
            for (ProbableGas gas : probable) {
                STREAM_CODEC.encode(buf, gas);
            }
        }
    };
    public static final List<ProbableGas> NONE = new ArrayList<ProbableGas>();
    private GasStack gas;
    private double chance;

    public ProbableGas(GasStack stack, double chance) {
        this.gas = stack;
        this.setChance(chance);
    }

    public GasStack getFullStack() {
        return this.gas;
    }

    private void setChance(double chance) {
        this.chance = chance > 1.0 ? 1.0 : (chance < 0.0 ? 0.0 : chance);
    }

    public double getChance() {
        return this.chance;
    }

    public GasStack roll() {
        double random = Voltaic.RANDOM.nextDouble();
        if (random > 1.0 - this.chance) {
            int amount = this.chance >= 1.0 ? this.gas.getAmount() : (int)((double)this.gas.getAmount() * random);
            return new GasStack(this.gas.getGas(), amount, this.gas.getTemperature(), this.gas.getPressure());
        }
        return GasStack.EMPTY;
    }
}

