/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.recipe.recipeutils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import voltaic.Voltaic;
import voltaic.api.codec.StreamCodec;

public class ProbableItem {
    public static final Codec<ProbableItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("item").forGetter(instance0 -> instance0.item), (App)Codec.DOUBLE.fieldOf("chance").forGetter(instance0 -> instance0.chance)).apply((Applicative)instance, ProbableItem::new));
    public static final Codec<List<ProbableItem>> LIST_CODEC = CODEC.listOf();
    public static final StreamCodec<FriendlyByteBuf, ProbableItem> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ProbableItem>(){

        @Override
        public ProbableItem decode(FriendlyByteBuf buf) {
            return new ProbableItem(StreamCodec.ITEM_STACK.decode(buf), buf.readDouble());
        }

        @Override
        public void encode(FriendlyByteBuf buf, ProbableItem item) {
            StreamCodec.ITEM_STACK.encode(buf, item.item);
            buf.writeDouble(item.chance);
        }
    };
    public static final StreamCodec<FriendlyByteBuf, List<ProbableItem>> LIST_STREAM_CODEC = new StreamCodec<FriendlyByteBuf, List<ProbableItem>>(){

        @Override
        public List<ProbableItem> decode(FriendlyByteBuf buf) {
            int count = buf.readInt();
            ArrayList<ProbableItem> items = new ArrayList<ProbableItem>();
            for (int i = 0; i < count; ++i) {
                items.add(STREAM_CODEC.decode(buf));
            }
            return items;
        }

        @Override
        public void encode(FriendlyByteBuf buf, List<ProbableItem> probable) {
            buf.writeInt(probable.size());
            for (ProbableItem item : probable) {
                STREAM_CODEC.encode(buf, item);
            }
        }
    };
    public static final List<ProbableItem> NONE = new ArrayList<ProbableItem>();
    private ItemStack item;
    private double chance;

    public ProbableItem(ItemStack stack, double chance) {
        this.item = stack;
        this.setChance(chance);
    }

    public ItemStack getFullStack() {
        return this.item;
    }

    private void setChance(double chance) {
        this.chance = chance > 1.0 ? 1.0 : (chance < 0.0 ? 0.0 : chance);
    }

    public double getChance() {
        return this.chance;
    }

    public ItemStack roll() {
        double random = Voltaic.RANDOM.nextDouble();
        if (random > 1.0 - this.chance) {
            double amount = this.chance >= 1.0 ? (double)this.item.m_41613_() : (double)this.item.m_41613_() * random;
            int itemCount = (int)Math.ceil(amount);
            return new ItemStack((ItemLike)this.item.m_41720_(), itemCount);
        }
        return ItemStack.f_41583_;
    }
}

