/*
 * Decompiled with CFR 0.152.
 */
package voltaic.compatibility.jei.recipecategories.fluiditem2fluid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import voltaic.common.recipe.categories.fluiditem2fluid.FluidItem2FluidRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.compatibility.jei.recipecategories.AbstractRecipeCategory;
import voltaic.compatibility.jei.utils.gui.types.BackgroundObject;
import voltaic.prefab.utilities.CapabilityUtils;

public abstract class FluidItem2FluidRecipeCategory<T extends FluidItem2FluidRecipe>
extends AbstractRecipeCategory<T> {
    public FluidItem2FluidRecipeCategory(IGuiHelper guiHelper, Component title, ItemStack inputMachine, BackgroundObject bWrap, RecipeType<T> recipeType, int animTime) {
        super(guiHelper, title, inputMachine, bWrap, recipeType, animTime);
    }

    @Override
    public List<List<FluidStack>> getFluidInputs(FluidItem2FluidRecipe recipe) {
        ArrayList<List<FluidStack>> ingredients = new ArrayList<List<FluidStack>>();
        for (FluidIngredient ing : recipe.getFluidIngredients()) {
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (FluidStack stack : ing.getMatchingFluids()) {
                if (BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid()).toString().toLowerCase(Locale.ROOT).contains("flow")) continue;
                fluids.add(stack);
            }
            ingredients.add(fluids);
        }
        return ingredients;
    }

    @Override
    public List<List<ItemStack>> getItemInputs(FluidItem2FluidRecipe recipe) {
        ArrayList<List<ItemStack>> ingredients = new ArrayList<List<ItemStack>>();
        for (CountableIngredient countableIngredient : recipe.getCountedIngredients()) {
            ingredients.add(Arrays.asList(countableIngredient.getItemsArray()));
        }
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            ArrayList<ItemStack> buckets = new ArrayList<ItemStack>();
            for (FluidStack stack : fluidIngredient.getMatchingFluids()) {
                ItemStack bucket = new ItemStack((ItemLike)stack.getFluid().m_6859_(), 1);
                IFluidHandlerItem handler = (IFluidHandlerItem)bucket.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
                if (handler != CapabilityUtils.EMPTY_FLUID_ITEM) {
                    handler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                    bucket = handler.getContainer();
                }
                buckets.add(bucket);
            }
            ingredients.add(buckets);
        }
        return ingredients;
    }

    @Override
    public List<ItemStack> getItemOutputs(FluidItem2FluidRecipe recipe) {
        ItemStack bucket;
        IFluidHandlerItem handler;
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        if (recipe.hasItemBiproducts()) {
            outputItems.addAll(Arrays.asList(recipe.getFullItemBiStacks()));
        }
        if ((handler = (IFluidHandlerItem)(bucket = new ItemStack((ItemLike)recipe.getFluidRecipeOutput().getFluid().m_6859_(), 1)).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM)) != CapabilityUtils.EMPTY_FLUID_ITEM) {
            handler.fill(recipe.getFluidRecipeOutput(), IFluidHandler.FluidAction.EXECUTE);
            bucket = handler.getContainer();
        }
        outputItems.add(bucket);
        if (recipe.hasFluidBiproducts()) {
            for (ProbableFluid stack : recipe.getFluidBiproducts()) {
                ItemStack temp = new ItemStack((ItemLike)stack.getFullStack().getFluid().m_6859_(), 1);
                handler = (IFluidHandlerItem)temp.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
                if (handler != CapabilityUtils.EMPTY_FLUID_ITEM) {
                    handler.fill(stack.getFullStack(), IFluidHandler.FluidAction.EXECUTE);
                    temp = handler.getContainer();
                }
                outputItems.add(temp);
            }
        }
        return outputItems;
    }

    @Override
    public List<FluidStack> getFluidOutputs(FluidItem2FluidRecipe recipe) {
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        outputFluids.add(recipe.getFluidRecipeOutput());
        if (recipe.hasFluidBiproducts()) {
            outputFluids.addAll(Arrays.asList(recipe.getFullFluidBiStacks()));
        }
        return outputFluids;
    }
}

