/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.client.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import voltaic.common.block.connect.EnumConnectType;

public class WireModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private ModelFile none;
    private ModelFile wire;
    private ModelFile inventory;

    public static <T extends ModelBuilder<T>> WireModelBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new WireModelBuilder<T>(parent, existingFileHelper);
    }

    protected WireModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(new ResourceLocation("voltaic", "voltaiccableloader"), parent, existingFileHelper);
    }

    public WireModelBuilder<T> models(ModelFile none, ModelFile wire, ModelFile inventory) {
        this.none = none;
        this.wire = wire;
        this.inventory = inventory;
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        JsonObject noneElement = new JsonObject();
        noneElement.addProperty("parent", this.none.getLocation().toString());
        json.add(EnumConnectType.NONE.toString(), (JsonElement)noneElement);
        JsonObject wireElement = new JsonObject();
        wireElement.addProperty("parent", this.wire.getLocation().toString());
        json.add(EnumConnectType.WIRE.toString(), (JsonElement)wireElement);
        JsonObject inventoryElement = new JsonObject();
        inventoryElement.addProperty("parent", this.inventory.getLocation().toString());
        json.add(EnumConnectType.INVENTORY.toString(), (JsonElement)inventoryElement);
        return json;
    }
}

