/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.server.radiation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.TagKey;
import voltaic.api.gas.Gas;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.registers.VoltaicRegistries;

public abstract class BaseRadioactiveGasesProvider
implements DataProvider {
    private final PackOutput output;
    private final String modID;
    private final String loc;

    public BaseRadioactiveGasesProvider(PackOutput output, String modID) {
        this.output = output;
        this.modID = modID;
        this.loc = "data/voltaic/radiation/" + modID + "_radioactive_gases";
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        JsonObject json = new JsonObject();
        this.getRadioactiveGases(json);
        Path parent = this.output.m_245114_().resolve(this.loc + ".json");
        return CompletableFuture.allOf(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)parent));
    }

    public abstract void getRadioactiveGases(JsonObject var1);

    public void addItem(Gas gas, double radiationAmount, double radiationStrength, JsonObject json) {
        JsonObject data = new JsonObject();
        json.add(VoltaicRegistries.gasRegistry().getKey((Object)gas).toString(), (JsonElement)RadioactiveObject.CODEC.encode((Object)new RadioactiveObject(radiationStrength, radiationAmount), (DynamicOps)JsonOps.INSTANCE, (Object)data).result().get());
    }

    public void addTag(TagKey<Gas> tag, double radiationAmount, double radiationStrength, JsonObject json) {
        JsonObject data = new JsonObject();
        json.add("#" + tag.f_203868_().toString(), (JsonElement)RadioactiveObject.CODEC.encode((Object)new RadioactiveObject(radiationStrength, radiationAmount), (DynamicOps)JsonOps.INSTANCE, (Object)data).result().get());
    }

    public String m_6055_() {
        return this.modID + " Radioactive Gases Provider";
    }
}

