/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.configuration;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Locale;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import voltaic.api.configuration.BooleanValue;
import voltaic.api.configuration.ByteValue;
import voltaic.api.configuration.Configuration;
import voltaic.api.configuration.DoubleValue;
import voltaic.api.configuration.FloatValue;
import voltaic.api.configuration.IntValue;
import voltaic.api.configuration.LongValue;
import voltaic.api.configuration.StringValue;

@Mod.EventBusSubscriber(modid="voltaic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigurationHandler {
    private static final HashSet<Class<?>> configurationMappings = new HashSet();
    private static final boolean DEBUG_MODE = false;

    public static void registerConfig(Class<?> configclass) {
        if (configclass.isAnnotationPresent(Configuration.class)) {
            configurationMappings.add(configclass);
        } else {
            new Exception("The class: " + configclass.getName() + " is not annotated by Configuration.class").printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onPreInit(FMLCommonSetupEvent event) {
        ConfigurationHandler.load();
    }

    /*
     * Could not resolve type clashes
     */
    public static void load() {
        for (Class<?> clazz : configurationMappings) {
            Configuration config = clazz.getAnnotation(Configuration.class);
            File file = new File(FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).toFile(), config.name().toLowerCase(Locale.ROOT) + ".txt");
            Field[] declaredFields = clazz.getDeclaredFields();
            try {
                if (!file.exists()) {
                    file.createNewFile();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    for (Field field : declaredFields) {
                        byte value;
                        String comment;
                        if (!Modifier.isPublic(field.getModifiers())) continue;
                        String name = field.getName();
                        if (field.isAnnotationPresent(IntValue.class)) {
                            comment = field.getAnnotation(IntValue.class).comment();
                            if (!comment.isEmpty()) {
                                writer.write("Comment: '" + comment + "'");
                                writer.newLine();
                            }
                            value = field.getInt(null);
                            writer.write("I:default=" + field.getAnnotation(IntValue.class).def() + " -> " + name + "='" + value + "'");
                        }
                        if (field.isAnnotationPresent(LongValue.class)) {
                            comment = field.getAnnotation(LongValue.class).comment();
                            if (!comment.isEmpty()) {
                                writer.write("Comment: '" + comment + "'");
                                writer.newLine();
                            }
                            long value2 = field.getLong(null);
                            writer.write("L:default=" + field.getAnnotation(LongValue.class).def() + " -> " + name + "='" + value2 + "'");
                        }
                        if (field.isAnnotationPresent(FloatValue.class)) {
                            comment = field.getAnnotation(FloatValue.class).comment();
                            if (!comment.isEmpty()) {
                                writer.write("Comment: '" + comment + "'");
                                writer.newLine();
                            }
                            float value3 = field.getFloat(null);
                            writer.write("F:default=" + field.getAnnotation(FloatValue.class).def() + " -> " + name + "='" + value3 + "'");
                        }
                        if (field.isAnnotationPresent(DoubleValue.class)) {
                            comment = field.getAnnotation(DoubleValue.class).comment();
                            if (!comment.isEmpty()) {
                                writer.write("Comment: '" + comment + "'");
                                writer.newLine();
                            }
                            double value4 = field.getDouble(null);
                            writer.write("D:default=" + field.getAnnotation(DoubleValue.class).def() + " -> " + name + "='" + value4 + "'");
                        }
                        if (field.isAnnotationPresent(StringValue.class)) {
                            comment = field.getAnnotation(StringValue.class).comment();
                            if (!comment.isEmpty()) {
                                writer.write("Comment: '" + comment + "'");
                                writer.newLine();
                            }
                            String value5 = (String)field.get(null);
                            writer.write("S:default=" + field.getAnnotation(StringValue.class).def() + " -> " + name + "='" + value5 + "'");
                        }
                        if (field.isAnnotationPresent(BooleanValue.class)) {
                            comment = field.getAnnotation(BooleanValue.class).comment();
                            if (!comment.isEmpty()) {
                                writer.write("Comment: '" + comment + "'");
                                writer.newLine();
                            }
                            value = field.getBoolean(null) ? 1 : 0;
                            writer.write("T:default=" + field.getAnnotation(BooleanValue.class).def() + " -> " + name + "='" + (value != 0) + "'");
                        }
                        if (field.isAnnotationPresent(ByteValue.class)) {
                            comment = field.getAnnotation(ByteValue.class).comment();
                            if (!comment.isEmpty()) {
                                writer.write("Comment: '" + comment + "'");
                                writer.newLine();
                            }
                            value = field.getByte(null);
                            writer.write("B:default=" + field.getAnnotation(ByteValue.class).def() + " -> " + name + "='" + value + "'");
                        }
                        writer.newLine();
                    }
                    writer.close();
                    continue;
                }
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                HashSet<Field> found = new HashSet<Field>();
                for (Field field : declaredFields) {
                    if (!Modifier.isPublic(field.getModifiers())) continue;
                    found.add(field);
                }
                while (line != null) {
                    if (!line.startsWith("Comment: ") && !line.startsWith("//") && !line.isEmpty() && line.contains(" -> ")) {
                        line = line.substring(10);
                        line = line.substring(line.indexOf(" -> "));
                        line = line.replace("'", "");
                        line = line.substring(4);
                        String[] split = line.split("=");
                        try {
                            Field field = clazz.getDeclaredField(split[0]);
                            if (field.isAnnotationPresent(IntValue.class)) {
                                field.setInt(null, Integer.parseInt(split[1]));
                            }
                            if (field.isAnnotationPresent(LongValue.class)) {
                                field.setLong(null, Long.parseLong(split[1]));
                            }
                            if (field.isAnnotationPresent(FloatValue.class)) {
                                field.setFloat(null, Float.parseFloat(split[1]));
                            }
                            if (field.isAnnotationPresent(DoubleValue.class)) {
                                field.setDouble(null, Double.parseDouble(split[1]));
                            }
                            if (field.isAnnotationPresent(StringValue.class)) {
                                field.set(null, split[1]);
                            }
                            if (field.isAnnotationPresent(BooleanValue.class)) {
                                field.setBoolean(null, Boolean.parseBoolean(split[1]));
                            }
                            if (field.isAnnotationPresent(ByteValue.class)) {
                                field.setByte(null, Byte.parseByte(split[1]));
                            }
                            found.remove(field);
                        }
                        catch (Exception e) {
                            System.out.println("Invalid field found in config file '" + file.getName() + "'");
                            System.out.println("Full: " + line);
                            System.out.println("Field: " + split[0]);
                            System.out.println("Value: " + split[1]);
                        }
                    }
                    line = reader.readLine();
                }
                reader.close();
                file.delete();
                file.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                for (Field field : declaredFields) {
                    byte value;
                    String comment;
                    if (!Modifier.isPublic(field.getModifiers())) continue;
                    String name = field.getName();
                    if (field.isAnnotationPresent(IntValue.class)) {
                        comment = field.getAnnotation(IntValue.class).comment();
                        if (!comment.isEmpty()) {
                            writer.write("Comment: '" + comment + "'");
                            writer.newLine();
                        }
                        value = field.getInt(null);
                        writer.write("I:default=" + field.getAnnotation(IntValue.class).def() + " -> " + name + "='" + value + "'");
                    }
                    if (field.isAnnotationPresent(LongValue.class)) {
                        comment = field.getAnnotation(LongValue.class).comment();
                        if (!comment.isEmpty()) {
                            writer.write("Comment: '" + comment + "'");
                            writer.newLine();
                        }
                        long value6 = field.getLong(null);
                        writer.write("L:default=" + field.getAnnotation(LongValue.class).def() + " -> " + name + "='" + value6 + "'");
                    }
                    if (field.isAnnotationPresent(FloatValue.class)) {
                        comment = field.getAnnotation(FloatValue.class).comment();
                        if (!comment.isEmpty()) {
                            writer.write("Comment: '" + comment + "'");
                            writer.newLine();
                        }
                        float value7 = field.getFloat(null);
                        writer.write("F:default=" + field.getAnnotation(FloatValue.class).def() + " -> " + name + "='" + value7 + "'");
                    }
                    if (field.isAnnotationPresent(DoubleValue.class)) {
                        comment = field.getAnnotation(DoubleValue.class).comment();
                        if (!comment.isEmpty()) {
                            writer.write("Comment: '" + comment + "'");
                            writer.newLine();
                        }
                        double value8 = field.getDouble(null);
                        writer.write("D:default=" + field.getAnnotation(DoubleValue.class).def() + " -> " + name + "='" + value8 + "'");
                    }
                    if (field.isAnnotationPresent(StringValue.class)) {
                        comment = field.getAnnotation(StringValue.class).comment();
                        if (!comment.isEmpty()) {
                            writer.write("Comment: '" + comment + "'");
                            writer.newLine();
                        }
                        String value9 = (String)field.get(null);
                        writer.write("S:default=" + field.getAnnotation(StringValue.class).def() + " -> " + name + "='" + value9 + "'");
                    }
                    if (field.isAnnotationPresent(BooleanValue.class)) {
                        comment = field.getAnnotation(BooleanValue.class).comment();
                        if (!comment.isEmpty()) {
                            writer.write("Comment: '" + comment + "'");
                            writer.newLine();
                        }
                        value = field.getBoolean(null) ? 1 : 0;
                        writer.write("T:default=" + field.getAnnotation(BooleanValue.class).def() + " -> " + name + "='" + (value != 0) + "'");
                    }
                    if (field.isAnnotationPresent(ByteValue.class)) {
                        comment = field.getAnnotation(ByteValue.class).comment();
                        if (!comment.isEmpty()) {
                            writer.write("Comment: '" + comment + "'");
                            writer.newLine();
                        }
                        value = field.getByte(null);
                        writer.write("B:default=" + field.getAnnotation(ByteValue.class).def() + " -> " + name + "='" + value + "'");
                    }
                    writer.newLine();
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

