/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.item;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.item.IItemElectric;
import voltaic.common.item.ItemVoltaic;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ItemElectric
extends ItemVoltaic
implements IItemElectric {
    private final ElectricItemProperties properties;
    private final Function<Item, Item> getBatteryItem;

    public ItemElectric(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab, Function<Item, Item> getBatteryItem) {
        super(properties, creativeTab);
        this.properties = properties;
        this.getBatteryItem = getBatteryItem;
    }

    @Override
    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        ItemStack empty = new ItemStack((ItemLike)this);
        items.add(empty);
        ItemStack charged = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored(charged, this.getMaximumCapacity(charged));
        items.add(charged);
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(13.0 * this.getJoulesStored(stack) / this.getMaximumCapacity(stack));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getJoulesStored(stack) < this.getMaximumCapacity(stack);
    }

    public void m_7373_(ItemStack stack, Level context, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, context, tooltip, flagIn);
        tooltip.add((Component)VoltaicTextUtils.tooltip("item.electric.info", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort(this.getJoulesStored(stack), DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort(this.getMaximumCapacity(stack), DisplayUnits.JOULES)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)VoltaicTextUtils.tooltip("item.electric.voltage", ChatFormatter.getChatDisplayShort(this.properties.receive.getVoltage(), DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        if (this.getDefaultStorageBattery() != Items.f_41852_) {
            IItemElectric.addBatteryTooltip(stack, context, tooltip);
        }
    }

    @Override
    public ElectricItemProperties getElectricProperties() {
        return this.properties;
    }

    @Override
    public Item getDefaultStorageBattery() {
        return this.getBatteryItem.apply(this);
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!IItemElectric.overrideOtherStackedOnMe(stack, other, slot, action, player, access)) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        return true;
    }
}

