/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.properties.types;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import voltaic.api.codec.StreamCodec;
import voltaic.prefab.properties.types.IPropertyType;

public class SetPropertyType<TYPE, BUFFERTYPE extends ByteBuf>
implements IPropertyType<HashSet<TYPE>, BUFFERTYPE> {
    private final BiPredicate<TYPE, TYPE> singleComparison;
    private final BiPredicate<HashSet<TYPE>, HashSet<TYPE>> comparison;
    private final StreamCodec<BUFFERTYPE, HashSet<TYPE>> packetCodec;
    private final Consumer<IPropertyType.TagWriter<HashSet<TYPE>>> writeToNbt;
    private final Function<IPropertyType.TagReader<HashSet<TYPE>>, HashSet<TYPE>> readFromNbt;

    public SetPropertyType(@Nonnull BiPredicate<TYPE, TYPE> singleComparison, final StreamCodec<BUFFERTYPE, TYPE> singlePacketCodec, Codec<TYPE> singleNbtCodec) {
        this.singleComparison = singleComparison;
        this.comparison = (set1, set2) -> {
            if (set1 == null || set2 == null) {
                return false;
            }
            if (set1.size() != set2.size()) {
                return false;
            }
            return set1.equals(set2);
        };
        this.packetCodec = new StreamCodec<BUFFERTYPE, HashSet<TYPE>>(){

            @Override
            public HashSet<TYPE> decode(BUFFERTYPE buffer) {
                int size = buffer.readInt();
                HashSet newSet = new HashSet();
                for (int i = 0; i < size; ++i) {
                    newSet.add(singlePacketCodec.decode(buffer));
                }
                return newSet;
            }

            @Override
            public void encode(BUFFERTYPE buffer, HashSet<TYPE> value) {
                buffer.writeInt(value.size());
                for (Object val : value) {
                    singlePacketCodec.encode(buffer, val);
                }
            }
        };
        this.writeToNbt = writer -> {
            CompoundTag tag = new CompoundTag();
            HashSet set = (HashSet)writer.prop().getValue();
            tag.m_128405_("size", set.size());
            int index = 0;
            for (Object val : set) {
                int indx = index++;
                singleNbtCodec.encode(val, (DynamicOps)NbtOps.f_128958_, (Object)NbtOps.f_128958_.empty()).result().ifPresent(nbt -> tag.m_128365_("" + indx, nbt));
            }
            writer.tag().m_128365_(writer.prop().getName(), (Tag)tag);
        };
        this.readFromNbt = reader -> {
            CompoundTag data = reader.tag().m_128469_(reader.prop().getName());
            if (!data.m_128441_("size")) {
                return (HashSet)reader.prop().getValue();
            }
            int size = data.m_128451_("size");
            HashSet set = new HashSet();
            if (size <= 0) {
                return set;
            }
            for (int i = 0; i < size; ++i) {
                singleNbtCodec.decode((DynamicOps)NbtOps.f_128958_, (Object)data.m_128423_("" + i)).result().ifPresent(pair -> set.add(pair.getFirst()));
            }
            return set;
        };
    }

    @Override
    public StreamCodec<BUFFERTYPE, HashSet<TYPE>> getPacketCodec() {
        return this.packetCodec;
    }

    @Override
    public void writeToTag(IPropertyType.TagWriter<HashSet<TYPE>> writer) {
        this.writeToNbt.accept(writer);
    }

    @Override
    public HashSet<TYPE> readFromTag(IPropertyType.TagReader<HashSet<TYPE>> reader) {
        return this.readFromNbt.apply(reader);
    }

    @Override
    public boolean isEqual(HashSet<TYPE> currentValue, HashSet<TYPE> newValue) {
        return this.comparison.test(currentValue, newValue);
    }

    public boolean isSingleEqual(TYPE val1, TYPE val2) {
        return this.singleComparison.test(val1, val2);
    }
}

