/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import voltaic.Voltaic;
import voltaic.api.screen.IScreenWrapper;
import voltaic.api.screen.component.ISlotTexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.ScreenComponentSlot;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.screen.component.utils.SlotTextureProvider;
import voltaic.prefab.utilities.math.Color;

@OnlyIn(value=Dist.CLIENT)
public class GenericScreen<T extends GenericContainer>
extends AbstractContainerScreen<T>
implements IScreenWrapper {
    protected ResourceLocation defaultResource = Voltaic.rl("textures/screen/component/base.png");
    private List<AbstractScreenComponent> components = new ArrayList<AbstractScreenComponent>();
    public List<ScreenComponentSlot> slots = new ArrayList<ScreenComponentSlot>();
    private List<ScreenComponentEditBox> editBoxes = new ArrayList<ScreenComponentEditBox>();
    protected int playerInvOffset = 0;
    public ScreenComponentSimpleLabel guiTitle;
    public ScreenComponentSimpleLabel playerInvLabel;

    public GenericScreen(T container, Inventory inv, Component title) {
        super(container, inv, title);
        this.initializeComponents();
    }

    protected void initializeComponents() {
        for (Slot slot : ((GenericContainer)this.f_97732_).f_38839_) {
            ScreenComponentSlot component = this.createScreenSlot(slot);
            this.addComponent(component);
            this.slots.add(component);
        }
        this.guiTitle = new ScreenComponentSimpleLabel(this.f_97728_, this.f_97729_, 10, Color.TEXT_GRAY, this.f_96539_);
        this.addComponent(this.guiTitle);
        this.playerInvLabel = new ScreenComponentSimpleLabel(this.f_97730_, this.f_97731_, 10, Color.TEXT_GRAY, this.f_169604_);
        this.addComponent(this.playerInvLabel);
    }

    protected ScreenComponentSlot createScreenSlot(Slot slot) {
        if (slot instanceof SlotTextureProvider) {
            SlotTextureProvider provider = (SlotTextureProvider)slot;
            ISlotTexture texture = provider.getSlotType();
            return new ScreenComponentSlot(slot, texture, provider.getIconType(), slot.f_40220_ + texture.xOffset(), slot.f_40221_ + texture.yOffset());
        }
        return new ScreenComponentSlot(slot, ScreenComponentSlot.SlotType.NORMAL, ScreenComponentSlot.IconType.NONE, slot.f_40220_ + ScreenComponentSlot.SlotType.NORMAL.xOffset(), slot.f_40221_ + ScreenComponentSlot.SlotType.NORMAL.yOffset());
    }

    protected void m_181908_() {
        super.m_181908_();
        for (ScreenComponentEditBox box : this.editBoxes) {
            box.tick();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiTitle.xLocation = this.f_97728_;
        this.guiTitle.yLocation = this.f_97729_;
        this.playerInvLabel.xLocation = this.f_97730_;
        this.playerInvLabel.yLocation = this.f_97731_;
        for (AbstractScreenComponent component : this.components) {
            this.m_142416_(component);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        int guiWidth = (int)this.getGuiWidth();
        int guiHeight = (int)this.getGuiHeight();
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        for (AbstractScreenComponent component : this.components) {
            component.renderForeground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int guiHeight;
        int guiWidth = (int)this.getGuiWidth();
        int y = guiHeight = (int)this.getGuiHeight();
        graphics.m_280163_(this.defaultResource, guiWidth, y, 0.0f, 0.0f, 176, 4, 176, 18);
        y += 4;
        int wholeHeight = (this.f_97727_ - 8) / 10;
        int remainder = (this.f_97727_ - 8) % 10;
        for (int i = 0; i < wholeHeight; ++i) {
            graphics.m_280163_(this.defaultResource, guiWidth, y, 0.0f, 4.0f, 176, 10, 176, 18);
            y += 10;
        }
        graphics.m_280163_(this.defaultResource, guiWidth, y, 0.0f, 4.0f, 176, remainder, 176, 18);
        graphics.m_280163_(this.defaultResource, guiWidth, y += remainder, 0.0f, 14.0f, 176, 4, 176, 18);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (AbstractScreenComponent component : this.components) {
            component.preOnMouseClick(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public Font getFontRenderer() {
        return Minecraft.m_91087_().f_91062_;
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        ArrayList<String> strings = new ArrayList<String>();
        ArrayList<ScreenComponentEditBox> boxes = new ArrayList<ScreenComponentEditBox>(this.editBoxes);
        for (ScreenComponentEditBox box : boxes) {
            strings.add(box.getValue());
        }
        super.m_6574_(pMinecraft, pWidth, pHeight);
        for (int i = 0; i < boxes.size(); ++i) {
            ((ScreenComponentEditBox)boxes.get(i)).setValue((String)strings.get(i));
        }
    }

    @Override
    public double getGuiWidth() {
        return (double)(this.f_96543_ - this.f_97726_) / 2.0;
    }

    @Override
    public double getGuiHeight() {
        return (double)(this.f_96544_ - this.f_97727_) / 2.0;
    }

    public double getXAxis(double mouseX) {
        return mouseX - this.getGuiWidth();
    }

    public double getYAxis(double mouseY) {
        return mouseY - this.getGuiHeight();
    }

    public AbstractScreenComponent addComponent(AbstractScreenComponent component) {
        this.components.add(component);
        component.setScreen(this);
        return component;
    }

    public List<AbstractScreenComponent> getComponents() {
        return this.components;
    }

    public void addEditBox(ScreenComponentEditBox box) {
        this.editBoxes.add(box);
        this.addComponent(box);
    }
}

