/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component;

import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenComponentGeneric
extends AbstractScreenComponent {
    public ITexture texture;
    @Nullable
    public ITexture icon;
    public Color color = Color.WHITE;
    @Nullable
    public AbstractScreenComponent.OnTooltip onTooltip = null;

    public ScreenComponentGeneric(ITexture texture, int x, int y) {
        super(x, y, texture.textureWidth(), texture.textureHeight());
        this.texture = texture;
    }

    public ScreenComponentGeneric(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.texture = ITexture.Textures.NONE;
    }

    public ScreenComponentGeneric setColor(Color color) {
        this.color = color;
        return this;
    }

    public ScreenComponentGeneric onTooltip(AbstractScreenComponent.OnTooltip onTooltip) {
        this.onTooltip = onTooltip;
        return this;
    }

    public ScreenComponentGeneric setIcon(ITexture icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (!this.isVisible()) {
            return;
        }
        RenderingUtils.setShaderColor(this.color);
        graphics.m_280163_(this.texture.getLocation(), guiWidth + this.xLocation, guiHeight + this.yLocation, (float)this.texture.textureU(), (float)this.texture.textureV(), this.texture.textureWidth(), this.texture.textureHeight(), this.texture.imageWidth(), this.texture.imageHeight());
        if (this.icon != null) {
            int xOffset = (this.texture.imageWidth() - this.icon.imageWidth()) / 2;
            int yOffset = (this.texture.imageHeight() - this.icon.imageHeight()) / 2;
            graphics.m_280163_(this.icon.getLocation(), guiWidth + this.xLocation + xOffset, guiHeight + this.yLocation + yOffset, (float)this.icon.textureU(), (float)this.icon.textureV(), this.icon.textureWidth(), this.icon.textureHeight(), this.icon.imageWidth(), this.icon.imageHeight());
        }
        RenderingUtils.resetShaderColor();
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderForeground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        if (this.isVisible() && this.isHovered() && this.onTooltip != null) {
            this.onTooltip.onTooltip(graphics, this, xAxis, yAxis);
        }
    }
}

