/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.button;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.RenderingUtils;

public class ScreenComponentButton<T extends ScreenComponentButton<?>>
extends ScreenComponentGeneric {
    public boolean isPressed = false;
    public final boolean isVanillaRender;
    @Nullable
    public OnPress onPress = null;
    @Nullable
    public Supplier<Component> label = null;
    public SoundEvent pressSound = (SoundEvent)SoundEvents.f_12490_.m_203334_();

    public ScreenComponentButton(ITexture texture, int x, int y) {
        super(texture, x, y);
        this.isVanillaRender = false;
    }

    public ScreenComponentButton(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.isVanillaRender = true;
        this.width = width;
        this.height = height;
    }

    public T setLabel(Component label) {
        return this.setLabel(() -> label);
    }

    public T setLabel(Supplier<Component> label) {
        this.label = label;
        return (T)this;
    }

    public T setOnPress(OnPress onPress) {
        this.onPress = onPress;
        return (T)this;
    }

    public T onTooltip(AbstractScreenComponent.OnTooltip onTooltip) {
        this.onTooltip = onTooltip;
        return (T)this;
    }

    public T setPressSound(SoundEvent sound) {
        this.pressSound = sound;
        return (T)this;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (this.isVanillaRender && this.isVisible()) {
            Minecraft minecraft = Minecraft.m_91087_();
            VanillaButtonTextures buttonTexture = this.isHovered() ? VanillaButtonTextures.BUTTON_ON : VanillaButtonTextures.BUTTON_OFF;
            RenderingUtils.setShaderColor(this.color);
            ScreenComponentEditBox.drawExpandedBox(graphics, buttonTexture.getLocation(), this.xLocation + guiWidth, this.yLocation + guiHeight, this.width, this.height);
            if (this.icon != null) {
                int xOffset = (this.width - this.icon.imageWidth()) / 2;
                int yOffset = (this.height - this.icon.imageHeight()) / 2;
                graphics.m_280163_(this.icon.getLocation(), guiWidth + this.xLocation + xOffset, guiHeight + this.yLocation + yOffset, (float)this.icon.textureU(), (float)this.icon.textureV(), this.icon.textureWidth(), this.icon.textureHeight(), this.icon.imageWidth(), this.icon.imageHeight());
            }
            Font font = minecraft.f_91062_;
            if (this.label != null) {
                graphics.m_280653_(font, this.label.get(), this.xLocation + guiWidth + this.width / 2, this.yLocation + guiHeight + (this.height - 8) / 2, this.color.color());
            }
            RenderingUtils.resetShaderColor();
        } else {
            super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        }
    }

    public int getVanillaYImage(boolean isMouseOver) {
        if (!this.isVisible()) {
            return 0;
        }
        if (isMouseOver) {
            return 2;
        }
        return 1;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isActiveAndVisible() && this.isValidClick(button) && this.isInClickRegion(mouseX, mouseY)) {
            this.onMouseClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isValidClick(button)) {
            this.onMouseRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public void onMouseClick(double mouseX, double mouseY) {
        if (this.onPress != null) {
            this.onPress();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.isActiveAndVisible()) {
            return false;
        }
        if (keyCode != 257 && keyCode != 32 && keyCode != 335) {
            return false;
        }
        this.playDownSound(Minecraft.m_91087_().m_91106_());
        this.onPress();
        return true;
    }

    public void onPress() {
        this.onPress.onPress(this);
        this.playDownSound(Minecraft.m_91087_().m_91106_());
    }

    public boolean isValidMouseClick(int button) {
        return button == 0;
    }

    public void playDownSound(SoundManager soundManager) {
        soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.pressSound, (float)1.0f));
    }

    public static interface OnPress {
        public void onPress(ScreenComponentButton<?> var1);
    }

    public static enum VanillaButtonTextures implements ITexture
    {
        BUTTON_OFF(18, 18, 0, 0, 18, 18, "vanilla_button_off"),
        BUTTON_ON(18, 18, 0, 0, 18, 18, "vanilla_button_on");

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private VanillaButtonTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, String name) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = Voltaic.rl("textures/screen/component/button/" + name + ".png");
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

