/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.button.type;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.button.type.ButtonSpecificPage;

public class ButtonModuleSelector
extends ButtonSpecificPage {
    private boolean selected = false;

    public ButtonModuleSelector(int x, int y, int page, boolean selected) {
        super(GuidebookButtonTextures.CHECKBOX_OFF, x, y, page);
        this.selected = selected;
        this.onPress = button -> {
            ButtonModuleSelector selector = (ButtonModuleSelector)button;
            selector.selected = !selector.selected;
        };
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (this.selected && this.isVisible()) {
            GuidebookButtonTextures texture = GuidebookButtonTextures.CHECKBOX_ON;
            graphics.m_280163_(texture.getLocation(), this.xLocation + guiWidth, this.yLocation + guiHeight, (float)texture.textureU(), (float)texture.textureV(), texture.textureWidth(), texture.textureHeight(), texture.imageWidth(), texture.imageHeight());
        } else {
            super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public static enum GuidebookButtonTextures implements ITexture
    {
        CHECKBOX_OFF(9, 9, 0, 0, 9, 9, "checkboxoff"),
        CHECKBOX_ON(9, 9, 0, 0, 9, 9, "checkboxon");

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private GuidebookButtonTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, String name) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = Voltaic.rl("textures/screen/guidebook/buttons/" + name + ".png");
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

