/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import voltaic.common.packet.NetworkHandler;
import voltaic.common.packet.types.server.PacketUpdateCarriedItemServer;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.types.ScreenComponentSlot;
import voltaic.prefab.tile.GenericTile;

public class ScreenComponentCondensedFluid
extends ScreenComponentGeneric {
    private final Supplier<SingleProperty<FluidStack>> fluidPropertySupplier;

    public ScreenComponentCondensedFluid(Supplier<SingleProperty<FluidStack>> fluidStackSupplier, int x, int y) {
        super(ScreenComponentSlot.IconType.FLUID_DARK, x, y);
        this.fluidPropertySupplier = fluidStackSupplier;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        SingleProperty<FluidStack> fluidProperty = this.fluidPropertySupplier.get();
        if (fluidProperty == null || ((FluidStack)fluidProperty.getValue()).isEmpty()) {
            return;
        }
        ScreenComponentSlot.IconType fluidFull = ScreenComponentSlot.IconType.FLUID_BLUE;
        graphics.m_280163_(fluidFull.getLocation(), guiWidth + this.xLocation + 1, guiHeight + this.yLocation + 1, (float)fluidFull.textureU(), (float)fluidFull.textureV(), fluidFull.textureWidth(), fluidFull.textureHeight(), fluidFull.imageWidth(), fluidFull.imageHeight());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isActiveAndVisible() && this.isValidClick(button) && this.isInClickRegion(mouseX, mouseY)) {
            this.onMouseClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isValidClick(button)) {
            this.onMouseRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public void onMouseClick(double mouseX, double mouseY) {
        SingleProperty<FluidStack> fluidProperty = this.fluidPropertySupplier.get();
        if (fluidProperty == null || ((FluidStack)fluidProperty.getValue()).isEmpty()) {
            return;
        }
        FluidStack fluidStack = (FluidStack)fluidProperty.getValue();
        GenericScreen screen = (GenericScreen)this.gui;
        GenericTile owner = (GenericTile)((GenericContainerBlockEntity)screen.m_6262_()).getSafeHost();
        if (owner == null) {
            return;
        }
        ItemStack stack = ((GenericContainer)screen.m_6262_()).m_142621_();
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
        if (handler == null) {
            return;
        }
        int taken = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        if (taken <= 0) {
            return;
        }
        fluidStack.shrink(taken);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11781_, (float)1.0f));
        stack = handler.getContainer();
        NetworkHandler.CHANNEL.sendToServer((Object)new PacketUpdateCarriedItemServer(stack.m_41777_(), owner.m_58899_(), Minecraft.m_91087_().f_91074_.m_20148_()));
    }
}

