/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenComponentInventoryIO
extends ScreenComponentGeneric {
    public static final int SQUARE_SIZE = 6;
    public static final int COLORS_PER_ROW = 4;
    public static final int DRAWING_AREA_SIZE = 24;
    public Color SLOT_GRAY = new Color(150, 150, 150, 255);
    private final Direction side;

    public ScreenComponentInventoryIO(int x, int y, Direction side) {
        super(InventoryIOTextures.DEFAULT, x, y);
        this.onTooltip((graphics, component, xAxis, yAxis) -> graphics.m_280557_(this.gui.getFontRenderer(), (Component)this.getLabelFromDir(), xAxis, yAxis));
        this.side = side;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        GenericScreen screen = (GenericScreen)this.gui;
        GenericContainerBlockEntity container = (GenericContainerBlockEntity)screen.m_6262_();
        GenericTile tile = (GenericTile)container.getSafeHost();
        if (tile == null || !tile.hasComponent(IComponentType.Inventory)) {
            return;
        }
        ComponentInventory inv = (ComponentInventory)tile.getComponent(IComponentType.Inventory);
        HashSet<Integer> slots = inv.relativeDirectionToSlotsMap[this.side.ordinal()];
        if (slots == null) {
            return;
        }
        ArrayList<Color> uniqueColors = new ArrayList<Color>();
        slots.forEach(slot -> {
            SlotGeneric generic = (SlotGeneric)container.f_38839_.get(slot.intValue());
            if (generic.ioColor == null) {
                return;
            }
            for (Color col : uniqueColors) {
                if (!col.equals(generic.ioColor)) continue;
                return;
            }
            uniqueColors.add(generic.ioColor);
        });
        if (uniqueColors.isEmpty()) {
            return;
        }
        if (uniqueColors.size() <= 16) {
            this.fillSquare(graphics, uniqueColors, this.xLocation + guiWidth, this.yLocation + guiHeight);
            return;
        }
        throw new UnsupportedOperationException("There are more than 16 unique colors mapped to a face!");
    }

    private void fillSquare(GuiGraphics graphics, List<Color> colors, int x, int y) {
        int wholeRows = colors.size() / 4;
        int lastRowCount = colors.size() % 4;
        int wholeHeight = 24 / (wholeRows + 1);
        int remainderHeight = 24 - wholeHeight * wholeRows;
        int index = 0;
        for (int i = 0; i < wholeRows; ++i) {
            for (int j = 0; j < 4; ++j) {
                graphics.m_280509_(x + 1 + j * 6, y + 1 + i * wholeHeight, x + 1 + (j + 1) * 6, y + 1 + (i + 1) * wholeHeight, colors.get(index).multiply(this.SLOT_GRAY).color());
                ++index;
            }
        }
        int remainderWidth = 24 / lastRowCount;
        int lastToAdd = 24 - remainderWidth * lastRowCount;
        for (int i = 0; i < lastRowCount - 1; ++i) {
            graphics.m_280509_(x + 1 + i * remainderWidth, y + 1 + wholeHeight * wholeRows, x + 1 + (i + 1) * remainderWidth, y + 1 + wholeHeight * wholeRows + remainderHeight, colors.get(index).multiply(this.SLOT_GRAY).color());
            ++index;
        }
        graphics.m_280509_(x + 1 + remainderWidth * (lastRowCount - 1), y + 1 + wholeHeight * wholeRows, x + 1 + lastRowCount * remainderWidth + lastToAdd, y + 1 + wholeHeight * wholeRows + remainderHeight, colors.get(index).multiply(this.SLOT_GRAY).color());
    }

    private MutableComponent getLabelFromDir() {
        MutableComponent component = null;
        switch (this.side) {
            default: {
                component = VoltaicTextUtils.tooltip("inventoryio.bottom", new Object[0]);
                break;
            }
            case UP: {
                component = VoltaicTextUtils.tooltip("inventoryio.top", new Object[0]);
                break;
            }
            case EAST: {
                component = VoltaicTextUtils.tooltip("inventoryio.left", new Object[0]);
                break;
            }
            case WEST: {
                component = VoltaicTextUtils.tooltip("inventoryio.right", new Object[0]);
                break;
            }
            case NORTH: {
                component = VoltaicTextUtils.tooltip("inventoryio.front", new Object[0]);
                break;
            }
            case SOUTH: {
                component = VoltaicTextUtils.tooltip("inventoryio.back", new Object[0]);
            }
        }
        return component;
    }

    public static enum InventoryIOTextures implements ITexture
    {
        DEFAULT(26, 26, 0, 0, 26, 26, "slotio");

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private InventoryIOTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, String name) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = Voltaic.rl("textures/screen/component/io/" + name + ".png");
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

