/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.api.screen.component.ISlotTexture;
import voltaic.api.screen.component.TextSupplier;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.inventory.container.slot.utils.IUpgradeSlot;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.utilities.VoltaicTextUtils;

@OnlyIn(value=Dist.CLIENT)
public class ScreenComponentSlot
extends ScreenComponentGeneric {
    private final ISlotTexture slotType;
    private final ITexture iconType;
    private TextSupplier tooltip;
    private final Slot slot;

    public ScreenComponentSlot(Slot slot, ISlotTexture slotType, ITexture iconType, int x, int y) {
        super(slotType, x, y);
        this.slotType = slotType;
        this.iconType = iconType;
        this.slot = slot;
        this.onTooltip((graphics, component, xAxis, yAxis) -> {
            if (this.tooltip == null) {
                return;
            }
            graphics.m_280557_(this.gui.getFontRenderer(), this.tooltip.getText(), xAxis, yAxis);
        });
    }

    public ScreenComponentSlot(Slot slot, int x, int y) {
        this(slot, SlotType.NORMAL, IconType.NONE, x, y);
    }

    public ScreenComponentSlot(Slot slot, ISlotTexture slotType, ITexture iconType, int x, int y, TextSupplier tooltip) {
        this(slot, slotType, iconType, x, y);
        this.tooltip = tooltip;
    }

    public void tooltip(TextSupplier tooltip) {
        this.tooltip = tooltip;
    }

    public ScreenComponentSlot setHoverText(Slot slot) {
        this.tooltip = () -> slot.m_7993_().m_41619_() ? Component.m_237119_() : slot.m_7993_().m_41786_();
        return this;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        if (this.iconType == IconType.NONE) {
            return;
        }
        int slotXOffset = (this.slotType.imageWidth() - this.iconType.imageWidth()) / 2;
        int slotYOffset = (this.slotType.imageHeight() - this.iconType.imageHeight()) / 2;
        graphics.m_280163_(this.iconType.getLocation(), guiWidth + this.xLocation + slotXOffset, guiHeight + this.yLocation + slotYOffset, (float)this.iconType.textureU(), (float)this.iconType.textureV(), this.iconType.textureWidth(), this.iconType.textureHeight(), this.iconType.imageWidth(), this.iconType.imageHeight());
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        Slot slot;
        if (!this.slot.m_6659_()) {
            return;
        }
        super.renderForeground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        if (this.isHoveredOrFocused() && Screen.m_96637_() && (slot = this.slot) instanceof IUpgradeSlot) {
            IUpgradeSlot upgrade = (IUpgradeSlot)slot;
            ArrayList<FormattedCharSequence> tooltips = new ArrayList<FormattedCharSequence>();
            tooltips.add(VoltaicTextUtils.tooltip("validupgrades", new Object[0]).m_7532_());
            for (SubtypeItemUpgrade item : upgrade.getUpgrades()) {
                tooltips.add(item.name.m_130940_(ChatFormatting.GRAY).m_7532_());
            }
            graphics.m_280245_(this.gui.getFontRenderer(), tooltips, xAxis, yAxis);
        }
    }

    @Override
    public boolean isVisible() {
        return this.slot.m_6659_();
    }

    public static enum SlotType implements ISlotTexture
    {
        NORMAL(18, 18, 0, 0, 18, 18, "slot_regular"),
        BIG(26, 26, 0, 0, 26, 26, "slot_big", -5, -5);

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;
        private final int xOffset;
        private final int yOffset;

        private SlotType(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, String name) {
            this(textureWidth, textureHeight, textureU, textureV, imageWidth, imageHeight, name, -1, -1);
        }

        private SlotType(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, String name, int xOffset, int yOffset) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = Voltaic.rl("textures/screen/component/slot/" + name + ".png");
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }

        @Override
        public int xOffset() {
            return this.xOffset;
        }

        @Override
        public int yOffset() {
            return this.yOffset;
        }
    }

    public static enum IconType implements ITexture
    {
        NONE(0, 0, 0, 0, 0, 0, null),
        ENERGY_DARK(10, 10, 0, 0, 10, 10, "electricity_dark"),
        FLUID_DARK(14, 14, 0, 0, 14, 14, "fluid_dark"),
        GAS_DARK(16, 16, 0, 0, 16, 16, "gas_dark"),
        UPGRADE_DARK(12, 12, 0, 0, 12, 12, "upgrade_dark"),
        DRILL_HEAD_DARK(12, 12, 0, 0, 12, 12, "drill_head_dark"),
        TRASH_CAN_DARK(10, 10, 0, 0, 10, 10, "trash_can_dark"),
        FIBERGLASS_SHEET_DARK(16, 16, 0, 0, 16, 16, "fiberglasssheet_dark"),
        ENERGY_GREEN(14, 14, 0, 0, 14, 14, "electricity_green"),
        ENCHANTMENT(16, 16, 0, 0, 16, 16, "enchantment"),
        FLUID_BLUE(16, 16, 0, 0, 16, 16, "fluid_blue"),
        MINING_LOCATION(18, 18, 0, 0, 18, 18, "mining_location"),
        QUARRY_COMPONENTS(18, 18, 0, 0, 18, 18, "quarry_components"),
        TEMPERATURE(14, 14, 0, 0, 14, 14, "temperature"),
        THERMOMETER(16, 16, 0, 0, 16, 16, "thermometer"),
        PRESSURE_GAUGE(10, 10, 0, 0, 10, 10, "pressuredial"),
        INVENTORY_IO(16, 16, 0, 0, 16, 16, "inventoryio"),
        SONAR_PROFILE(16, 16, 0, 0, 16, 16, "sonarpattern"),
        CUBE_OUTLINE(16, 16, 0, 0, 16, 16, "cubeoutline");

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private IconType(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, String name) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = Voltaic.rl("textures/screen/component/icon/" + name + ".png");
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

