/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types.gauges;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.utilities.RenderingUtils;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractScreenComponentGauge
extends ScreenComponentGeneric {
    public static final ResourceLocation TEXTURE = Voltaic.rl("textures/screen/component/fluid.png");

    public AbstractScreenComponentGauge(int x, int y) {
        super(GaugeTextures.BACKGROUND_DEFAULT, x, y);
        this.onTooltip((graphics, component, xAxis, yAxis) -> {
            List<? extends FormattedCharSequence> tooltips = this.getTooltips();
            if (!tooltips.isEmpty()) {
                graphics.m_280245_(this.gui.getFontRenderer(), tooltips, xAxis, yAxis);
            }
        });
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        ResourceLocation texture = this.getTexture();
        int scale = this.getScaledLevel();
        if (texture != null && scale > 0) {
            ResourceLocation blocks = InventoryMenu.f_39692_;
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(blocks).apply(texture);
            RenderingUtils.bindTexture(sprite.m_247685_());
            this.applyColor();
            for (int i = 0; i < 16; i += 16) {
                for (int j = 0; j < scale; j += 16) {
                    int drawWidth = Math.min(this.texture.textureWidth() - 2 - i, 16);
                    int drawHeight = Math.min(scale - j, 16);
                    int drawX = guiWidth + this.xLocation + 1;
                    int drawY = guiHeight + this.yLocation - 1 + this.texture.textureHeight() - Math.min(scale - j, this.texture.textureHeight());
                    graphics.m_280159_(drawX, drawY, 0, drawWidth, drawHeight, sprite);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        graphics.m_280163_(this.texture.getLocation(), guiWidth + this.xLocation, guiHeight + this.yLocation, (float)GaugeTextures.LEVEL_DEFAULT.textureU(), 0.0f, GaugeTextures.LEVEL_DEFAULT.textureWidth(), GaugeTextures.LEVEL_DEFAULT.textureHeight(), GaugeTextures.LEVEL_DEFAULT.imageWidth(), GaugeTextures.LEVEL_DEFAULT.imageHeight());
    }

    protected abstract void applyColor();

    protected abstract int getScaledLevel();

    protected abstract ResourceLocation getTexture();

    protected abstract List<? extends FormattedCharSequence> getTooltips();

    public static enum GaugeTextures implements ITexture
    {
        BACKGROUND_DEFAULT(14, 49, 0, 0, 256, 256, TEXTURE),
        LEVEL_DEFAULT(14, 49, 14, 0, 256, 256, TEXTURE);

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private GaugeTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, ResourceLocation loc) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = loc;
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

