/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types.guitab;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.generator.IElectricGenerator;
import voltaic.api.screen.IScreenWrapper;
import voltaic.api.screen.component.TextPropertySupplier;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentSlot;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.utils.AbstractScreenComponentInfo;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.object.TransferPack;

@OnlyIn(value=Dist.CLIENT)
public class ScreenComponentElectricInfo
extends ScreenComponentGuiTab {
    private Function<ComponentElectrodynamic, Double> wattage = null;

    public ScreenComponentElectricInfo(TextPropertySupplier infoHandler, int x, int y) {
        super(ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, ScreenComponentSlot.IconType.ENERGY_GREEN, infoHandler, x, y);
    }

    public ScreenComponentElectricInfo(int x, int y) {
        this(AbstractScreenComponentInfo.EMPTY, x, y);
    }

    public ScreenComponentElectricInfo wattage(double wattage) {
        return this.wattage(e -> wattage);
    }

    public ScreenComponentElectricInfo wattage(Function<ComponentElectrodynamic, Double> wattage) {
        this.wattage = wattage;
        return this;
    }

    @Override
    protected List<? extends FormattedCharSequence> getInfo(List<? extends FormattedCharSequence> list) {
        if (this.infoHandler == EMPTY) {
            return this.getElectricInformation();
        }
        return super.getInfo(list);
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        GenericTile tile;
        Object t;
        GenericScreen menu;
        Object t2;
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        IScreenWrapper iScreenWrapper = this.gui;
        if (iScreenWrapper instanceof GenericScreen && (t2 = ((GenericContainerBlockEntity)(menu = (GenericScreen)iScreenWrapper).m_6262_()).getUnsafeHost()) instanceof GenericTile && (t = (tile = (GenericTile)t2).getComponent(IComponentType.Electrodynamic)) instanceof ComponentElectrodynamic) {
            ComponentElectrodynamic electro = (ComponentElectrodynamic)t;
            if (tile instanceof IElectricGenerator) {
                IElectricGenerator generator = (IElectricGenerator)((Object)tile);
                TransferPack transfer = generator.getProduced();
                list.add(VoltaicTextUtils.gui("machine.current", ChatFormatter.getChatDisplayShort(transfer.getAmps(), DisplayUnits.AMPERE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                list.add(VoltaicTextUtils.gui("machine.output", ChatFormatter.getChatDisplayShort(transfer.getWatts(), DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                list.add(VoltaicTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort(transfer.getVoltage(), DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            } else {
                double satisfaction = 0.0;
                if (this.wattage == null) {
                    double perTick = tile.hasComponent(IComponentType.Processor) ? ((ComponentProcessor)tile.getComponent(IComponentType.Processor)).getTotalUsage() * (Double)((ComponentProcessor)tile.getComponent((IComponentType)IComponentType.Processor)).operatingSpeed.getValue() : 0.0;
                    list.add(VoltaicTextUtils.gui("machine.usage", ChatFormatter.getChatDisplayShort(perTick * 20.0, DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                    if (perTick == 0.0) {
                        satisfaction = 1.0;
                    } else if (electro.getJoulesStored() > 0.0) {
                        satisfaction = electro.getJoulesStored() >= perTick ? 1.0 : electro.getJoulesStored() / perTick;
                    }
                } else {
                    double watts = this.wattage.apply(electro);
                    double perTick = watts / 20.0;
                    if (perTick == 0.0) {
                        satisfaction = 1.0;
                    } else if (electro.getJoulesStored() > 0.0) {
                        satisfaction = electro.getJoulesStored() >= perTick ? 1.0 : electro.getJoulesStored() / perTick;
                    }
                    list.add(VoltaicTextUtils.gui("machine.usage", ChatFormatter.getChatDisplayShort(watts, DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                }
                list.add(VoltaicTextUtils.gui("machine.voltage", ChatFormatter.getChatDisplayShort(electro.getVoltage(), DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                list.add(VoltaicTextUtils.gui("machine.satisfaction", ChatFormatter.getChatDisplayShort(satisfaction * 100.0, DisplayUnits.PERCENTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            }
        }
        return list;
    }
}

