/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types.wrapper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.type.ButtonTankSlider;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.gauges.ScreenComponentGasGauge;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.utils.IComponentGasHandler;
import voltaic.prefab.utilities.math.Color;

public class WrapperCyclableGasGauge {
    private int gauge = 0;
    private List<AbstractScreenComponent> components = new ArrayList<AbstractScreenComponent>();

    public WrapperCyclableGasGauge(int x, int y, GenericContainerBlockEntity<? extends GenericTile> container, GenericScreen<?> screen, boolean inputTanks) {
        int yOffset = 0;
        this.components.add(screen.addComponent(new ScreenComponentSimpleLabel(x + 4, y + yOffset, 7, Color.WHITE, () -> Component.m_237113_((String)("" + (this.gauge + 1))))));
        this.components.add(screen.addComponent(new ScreenComponentGasGauge(() -> {
            GenericTile tile = (GenericTile)container.getSafeHost();
            if (tile == null) {
                return null;
            }
            IComponentGasHandler handler = (IComponentGasHandler)tile.getComponent(IComponentType.GasHandler);
            if (handler == null) {
                return null;
            }
            return inputTanks ? handler.getInputTanks()[this.gauge] : handler.getOutputTanks()[this.gauge];
        }, x, y + (yOffset += 8))));
        this.components.add(screen.addComponent((AbstractScreenComponent)new ButtonTankSlider(ButtonTankSlider.TankSliderPair.LEFT, x, y + (yOffset += 50)).setOnPress(button -> {
            GenericTile tile = (GenericTile)container.getSafeHost();
            if (tile == null) {
                return;
            }
            IComponentGasHandler handler = (IComponentGasHandler)tile.getComponent(IComponentType.GasHandler);
            if (handler == null) {
                return;
            }
            int size = inputTanks ? handler.getInputTanks().length : handler.getOutputTanks().length;
            --this.gauge;
            if (this.gauge < 0) {
                this.gauge = size - 1;
            }
        })));
        this.components.add(screen.addComponent((AbstractScreenComponent)new ButtonTankSlider(ButtonTankSlider.TankSliderPair.RIGHT, x + 8, y + yOffset).setOnPress(button -> {
            GenericTile tile = (GenericTile)container.getSafeHost();
            if (tile == null) {
                return;
            }
            IComponentGasHandler handler = (IComponentGasHandler)tile.getComponent(IComponentType.GasHandler);
            if (handler == null) {
                return;
            }
            int size = inputTanks ? handler.getInputTanks().length : handler.getOutputTanks().length;
            ++this.gauge;
            if (size <= this.gauge) {
                this.gauge = 0;
            }
        })));
    }

    public List<AbstractScreenComponent> getComponents() {
        return this.components;
    }
}

