/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.components.type;

import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import voltaic.Voltaic;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.CapabilityInputType;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.object.TransferPack;
import voltaic.registers.VoltaicCapabilities;

public class ComponentForgeEnergy
implements IComponent {
    private GenericTile holder;
    private final boolean electroLoaded;
    private final ComponentElectrodynamic electro;

    public ComponentForgeEnergy(GenericTile holder) {
        this.holder = holder;
        if (!holder.hasComponent(IComponentType.Electrodynamic)) {
            throw new RuntimeException("You must define a ComponentElectrodynamic before defining a ComponentForgeEnergy!");
        }
        this.electro = (ComponentElectrodynamic)holder.getComponent(IComponentType.Electrodynamic);
        if (Voltaic.isElectroLoaded() == null) {
            throw new RuntimeException("You are doing something very wrong indeed");
        }
        this.electroLoaded = Voltaic.isElectroLoaded();
    }

    @Override
    public IComponentType getType() {
        return IComponentType.ForgeEnergy;
    }

    @Override
    public void holder(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    @Nullable
    public GenericTile getHolder() {
        return this.holder;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side, CapabilityInputType inputType) {
        if (this.electroLoaded || side == null) {
            return LazyOptional.empty();
        }
        ICapabilityElectrodynamic electrodynamic = (ICapabilityElectrodynamic)this.electro.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, side, inputType).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        return electrodynamic == CapabilityUtils.EMPTY_ELECTRO ? LazyOptional.empty() : LazyOptional.of(() -> new ElectrodynamicWrapper(electrodynamic)).cast();
    }

    private static final class ElectrodynamicWrapper
    implements IEnergyStorage {
        private final ICapabilityElectrodynamic electro;

        private ElectrodynamicWrapper(ICapabilityElectrodynamic electro) {
            this.electro = electro;
        }

        public int receiveEnergy(int toReceive, boolean simulate) {
            return (int)Math.ceil(this.electro.receivePower(TransferPack.joulesVoltage(toReceive, this.electro.getVoltage()), simulate).getJoules());
        }

        public int extractEnergy(int toExtract, boolean simulate) {
            return (int)this.electro.extractPower(TransferPack.joulesVoltage(toExtract, this.electro.getVoltage()), simulate).getJoules();
        }

        public int getEnergyStored() {
            return (int)this.electro.getJoulesStored();
        }

        public int getMaxEnergyStored() {
            return (int)this.electro.getMaxJoulesStored();
        }

        public boolean canExtract() {
            return this.electro.isEnergyProducer();
        }

        public boolean canReceive() {
            return this.electro.isEnergyReceiver();
        }
    }
}

