/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.components.type;

import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.api.gas.IGasHandler;
import voltaic.api.gas.PropertyGasTank;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.CapabilityInputType;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.utils.IComponentGasHandler;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.registers.VoltaicRegistries;

public class ComponentGasHandlerSimple
extends PropertyGasTank
implements IComponentGasHandler {
    @Nullable
    public Direction[] inputDirections;
    @Nullable
    public Direction[] outputDirections;
    private boolean isSided = false;
    @Nullable
    private TagKey<Gas>[] validGasTags;
    @Nullable
    private Gas[] validGases;
    private HashSet<Gas> validatorGases = new HashSet();
    private IGasHandler[] sidedOptionals = new IGasHandler[6];
    @Nullable
    private IGasHandler inputOptional = null;
    @Nullable
    private IGasHandler outputOptional = null;

    public ComponentGasHandlerSimple(GenericTile holder, String key, int capacity, int maxTemperature, int maxPressure) {
        super(holder, key, capacity, maxTemperature, maxPressure);
    }

    public ComponentGasHandlerSimple(GenericTile holder, String key, int capacity, int maxTemperature, int maxPressure, Predicate<GasStack> isGasValid) {
        super(holder, key, capacity, maxTemperature, maxPressure, isGasValid);
    }

    protected ComponentGasHandlerSimple(PropertyGasTank other) {
        super(other);
    }

    public ComponentGasHandlerSimple setInputDirections(BlockEntityUtils.MachineDirection ... directions) {
        this.isSided = true;
        this.inputDirections = BlockEntityUtils.MachineDirection.toDirectionArray(directions);
        return this;
    }

    public ComponentGasHandlerSimple setOutputDirections(BlockEntityUtils.MachineDirection ... directions) {
        this.isSided = true;
        this.outputDirections = BlockEntityUtils.MachineDirection.toDirectionArray(directions);
        return this;
    }

    public ComponentGasHandlerSimple universalInput() {
        this.inputDirections = Direction.values();
        return this;
    }

    public ComponentGasHandlerSimple universalOutput() {
        this.outputDirections = Direction.values();
        return this;
    }

    @Override
    public ComponentGasHandlerSimple setValidator(Predicate<GasStack> predicate) {
        return (ComponentGasHandlerSimple)super.setValidator((Predicate)predicate);
    }

    @Override
    public ComponentGasHandlerSimple setOnGasCondensed(BiConsumer<GasTank, GenericTile> onGasCondensed) {
        return (ComponentGasHandlerSimple)super.setOnGasCondensed(onGasCondensed);
    }

    public ComponentGasHandlerSimple setValidFluids(Gas ... fluids) {
        this.validGases = fluids;
        return this;
    }

    public ComponentGasHandlerSimple setValidFluidTags(TagKey<Gas> ... fluids) {
        this.validGasTags = fluids;
        return this;
    }

    @Override
    public PropertyGasTank[] getInputTanks() {
        return this.asArray();
    }

    @Override
    public PropertyGasTank[] getOutputTanks() {
        return this.asArray();
    }

    @Override
    public IComponentType getType() {
        return IComponentType.GasHandler;
    }

    @Override
    public void holder(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    public GenericTile getHolder() {
        return this.holder;
    }

    @Override
    public void refreshIfUpdate(BlockState oldState, BlockState newState) {
        if (this.isSided && oldState.m_61138_((Property)VoltaicBlockStates.FACING) && newState.m_61138_((Property)VoltaicBlockStates.FACING) && oldState.m_61143_((Property)VoltaicBlockStates.FACING) != newState.m_61143_((Property)VoltaicBlockStates.FACING)) {
            this.defineOptionals((Direction)newState.m_61143_((Property)VoltaicBlockStates.FACING));
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side, CapabilityInputType inputType) {
        if (!this.isSided) {
            return LazyOptional.of(() -> this).cast();
        }
        if (side == null) {
            return LazyOptional.empty();
        }
        IGasHandler cap = this.sidedOptionals[side.ordinal()];
        return cap == null ? LazyOptional.empty() : LazyOptional.of(() -> cap).cast();
    }

    @Override
    public void refresh() {
        this.defineOptionals(this.holder.getFacing());
    }

    private void defineOptionals(Direction facing) {
        this.holder.invalidateCaps();
        this.sidedOptionals = new IGasHandler[6];
        this.inputOptional = null;
        this.outputOptional = null;
        if (this.isSided) {
            if (this.inputDirections != null) {
                this.inputOptional = new InputTank(this);
                for (Direction dir : this.inputDirections) {
                    this.sidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.inputOptional;
                }
            }
            if (this.outputDirections != null) {
                this.outputOptional = new OutputTank(this);
                for (Direction dir : this.outputDirections) {
                    this.sidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.outputOptional;
                }
            }
        }
    }

    @Override
    public void onLoad() {
        IComponentGasHandler.super.onLoad();
        if (this.validGases != null) {
            for (Gas gas : this.validGases) {
                this.validatorGases.add(gas);
            }
        }
        if (this.validGasTags != null) {
            for (Gas gas : this.validGasTags) {
                for (Gas gas2 : VoltaicRegistries.gasRegistry().tags().getTag((TagKey)gas).stream().toList()) {
                    this.validatorGases.add(gas2);
                }
            }
        }
        if (!this.validatorGases.isEmpty()) {
            this.isGasValid = gasStack -> this.validatorGases.contains(gasStack.getGas());
        }
    }

    private class InputTank
    extends ComponentGasHandlerSimple {
        public InputTank(ComponentGasHandlerSimple property) {
            super(property);
        }

        @Override
        public GasStack drain(int amount, GasAction action) {
            return GasStack.EMPTY;
        }

        @Override
        public GasStack drain(GasStack resource, GasAction action) {
            return GasStack.EMPTY;
        }
    }

    private class OutputTank
    extends ComponentGasHandlerSimple {
        public OutputTank(ComponentGasHandlerSimple property) {
            super(property);
        }

        @Override
        public int fill(GasStack resource, GasAction action) {
            return 0;
        }
    }
}

