/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.components.type;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.logging.log4j.util.TriConsumer;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.api.gas.PropertyGasTank;
import voltaic.common.item.ItemUpgrade;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.common.network.utils.FluidUtilities;
import voltaic.common.network.utils.GasUtilities;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.categories.fluid2fluid.Fluid2FluidRecipe;
import voltaic.common.recipe.categories.fluid2gas.Fluid2GasRecipe;
import voltaic.common.recipe.categories.fluid2item.Fluid2ItemRecipe;
import voltaic.common.recipe.categories.fluiditem2fluid.FluidItem2FluidRecipe;
import voltaic.common.recipe.categories.fluiditem2gas.FluidItem2GasRecipe;
import voltaic.common.recipe.categories.fluiditem2item.FluidItem2ItemRecipe;
import voltaic.common.recipe.categories.item2fluid.Item2FluidRecipe;
import voltaic.common.recipe.categories.item2item.Item2ItemRecipe;
import voltaic.common.recipe.recipeutils.FluidIngredient;
import voltaic.common.recipe.recipeutils.ProbableFluid;
import voltaic.common.recipe.recipeutils.ProbableGas;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.ArrayProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.prefab.utilities.math.MathUtils;

public class ComponentProcessor
implements IComponent {
    private GenericTile holder;
    public final SingleProperty<Double> operatingSpeed;
    public final ArrayProperty<Double> operatingTicks;
    public final ArrayProperty<Double> usage;
    public final ArrayProperty<Double> requiredTicks;
    private BiPredicate<ComponentProcessor, Integer> canProcess = (component, index) -> false;
    private BiConsumer<ComponentProcessor, Integer> process = (component, index) -> {};
    private TriConsumer<ComponentProcessor, List<Integer>, Boolean> failed = (component, failedProcessors, anySuceeded) -> {};
    private final int numProcessors;
    private List<VoltaicRecipe> cachedRecipes = new ArrayList<VoltaicRecipe>();
    private final VoltaicRecipe[] activeRecipies;
    private double storedXp = 0.0;
    private ArrayProperty<Boolean> isActive;
    private ArrayProperty<Boolean> shouldKeepProgress;

    public ComponentProcessor(GenericTile source) {
        this(source, 1);
    }

    public ComponentProcessor(GenericTile source, int totalProcessors) {
        this.holder(source);
        this.numProcessors = totalProcessors;
        this.operatingSpeed = this.holder.property(new SingleProperty<Double>(PropertyTypes.DOUBLE, "operatingSpeed", Double.valueOf(1.0)));
        this.operatingTicks = this.holder.property(new ArrayProperty<Double>(PropertyTypes.DOUBLE_ARRAY, "operatingTicks", MathUtils.fillArr(new Double[totalProcessors], 0.0)));
        this.usage = this.holder.property(new ArrayProperty<Double>(PropertyTypes.DOUBLE_ARRAY, "recipeUsage", MathUtils.fillArr(new Double[totalProcessors], 0.0)));
        this.requiredTicks = this.holder.property(new ArrayProperty<Double>(PropertyTypes.DOUBLE_ARRAY, "requiredTicks", MathUtils.fillArr(new Double[totalProcessors], 0.0)));
        this.isActive = this.holder.property(new ArrayProperty<Boolean>(PropertyTypes.BOOLEAN_ARRAY, "isprocactive", MathUtils.fillArr(new Boolean[totalProcessors], false)));
        this.shouldKeepProgress = this.holder.property(new ArrayProperty<Boolean>(PropertyTypes.BOOLEAN_ARRAY, "shouldprockeepprogress", MathUtils.fillArr(new Boolean[totalProcessors], false)));
        this.activeRecipies = new VoltaicRecipe[totalProcessors];
        if (!this.holder.hasComponent(IComponentType.Inventory)) {
            throw new UnsupportedOperationException("You need to implement an inventory component to use the processor component!");
        }
        if (!this.holder.hasComponent(IComponentType.Tickable)) {
            throw new UnsupportedOperationException("You need to implement a tickable component to use the processor component!");
        }
        ((ComponentTickable)this.holder.getComponent(IComponentType.Tickable)).tickServer(this::tickServer);
    }

    @Override
    public void holder(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    public GenericTile getHolder() {
        return this.holder;
    }

    private void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.holder.getComponent(IComponentType.Electrodynamic);
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        for (ItemStack stack : inv.getUpgradeContents()) {
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ItemUpgrade)) continue;
            ItemUpgrade upgrade = (ItemUpgrade)item;
            if (upgrade.subtype.isEmpty) continue;
            for (int i = 0; i < stack.m_41613_(); ++i) {
                for (int j = 0; j < this.numProcessors; ++j) {
                    upgrade.subtype.applyUpgrade.accept((Object)this.getHolder(), (Object)stack, (Object)j);
                }
            }
        }
        boolean suceeded = false;
        ArrayList<Integer> failure = new ArrayList<Integer>();
        for (int procNumber = 0; procNumber < this.numProcessors; ++procNumber) {
            if (this.canProcess.test(this, procNumber)) {
                this.isActive.setValue(true, procNumber);
                this.operatingTicks.setValue(((Double[])this.operatingTicks.getValue())[procNumber] + (Double)this.operatingSpeed.getValue(), procNumber);
                if (((Double[])this.operatingTicks.getValue())[procNumber] >= ((Double[])this.requiredTicks.getValue())[procNumber]) {
                    if (this.process != null) {
                        this.process.accept(this, procNumber);
                        suceeded = true;
                    }
                    this.operatingTicks.setValue(0.0, procNumber);
                }
                if (!this.holder.hasComponent(IComponentType.Electrodynamic)) continue;
                electro.joules(electro.getJoulesStored() - ((Double[])this.usage.getValue())[procNumber] * (Double)this.operatingSpeed.getValue());
                continue;
            }
            if (this.isActive(procNumber)) {
                this.isActive.setValue(false, procNumber);
                if (!((Boolean[])this.shouldKeepProgress.getValue())[procNumber].booleanValue()) {
                    this.operatingTicks.setValue(0.0, procNumber);
                }
                if (this.failed == null) continue;
                failure.add(procNumber);
                continue;
            }
            this.operatingTicks.setValue(0.0, procNumber);
        }
        electro.maxJoules(this.getTotalUsage() * (Double)this.operatingSpeed.getValue() * 10.0);
        if (!failure.isEmpty()) {
            this.failed.accept((Object)this, failure, (Object)suceeded);
        }
    }

    public ComponentProcessor process(BiConsumer<ComponentProcessor, Integer> process) {
        this.process = process;
        return this;
    }

    public ComponentProcessor failed(TriConsumer<ComponentProcessor, List<Integer>, Boolean> failed) {
        this.failed = failed;
        return this;
    }

    public ComponentProcessor canProcess(BiPredicate<ComponentProcessor, Integer> canProcess) {
        this.canProcess = canProcess;
        return this;
    }

    public ComponentProcessor usageForAll(double usage) {
        for (int index = 0; index < this.numProcessors; ++index) {
            this.usage.setValue(usage, index);
        }
        return this;
    }

    public ComponentProcessor usage(double usage, int index) {
        this.usage.setValue(usage, index);
        return this;
    }

    public double getUsage(int index) {
        return ((Double[])this.usage.getValue())[index] * (Double)this.operatingSpeed.getValue();
    }

    public double getTotalUsage() {
        double total = 0.0;
        Double[] doubleArray = (Double[])this.usage.getValue();
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double use = doubleArray[i];
            total += use;
        }
        return total;
    }

    public ComponentProcessor requiredTicks(long requiredTicks, int index) {
        this.requiredTicks.setValue(requiredTicks, index);
        return this;
    }

    public ComponentProcessor requiredTicksForAll(long requiredTicks) {
        for (int index = 0; index < this.numProcessors; ++index) {
            this.requiredTicks.setValue(requiredTicks, index);
        }
        return this;
    }

    public int getProcessorCount() {
        return this.numProcessors;
    }

    @Override
    public IComponentType getType() {
        return IComponentType.Processor;
    }

    public ComponentProcessor consumeBucket() {
        FluidUtilities.drainItem(this.holder, ((ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler)).getInputTanks());
        return this;
    }

    public ComponentProcessor dispenseBucket() {
        FluidUtilities.fillItem(this.holder, ((ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler)).getOutputTanks());
        return this;
    }

    public ComponentProcessor outputToFluidPipe() {
        ComponentFluidHandlerMulti handler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        FluidUtilities.outputToPipe(this.holder, handler.getOutputTanks(), handler.outputDirections);
        return this;
    }

    public ComponentProcessor consumeGasCylinder() {
        GasUtilities.drainItem(this.holder, ((ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler)).getInputTanks());
        return this;
    }

    public ComponentProcessor dispenseGasCylinder() {
        GasUtilities.fillItem(this.holder, ((ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler)).getOutputTanks());
        return this;
    }

    public ComponentProcessor outputToGasPipe() {
        ComponentGasHandlerMulti handler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler);
        GasUtilities.outputToPipe(this.holder, handler.getOutputTanks(), handler.outputDirections);
        return this;
    }

    public VoltaicRecipe getRecipe(int index) {
        return this.activeRecipies[index];
    }

    public void setRecipe(VoltaicRecipe recipe, int index) {
        this.activeRecipies[index] = recipe;
    }

    public void setStoredXp(double val) {
        this.storedXp = val;
    }

    public double getStoredXp() {
        return this.storedXp;
    }

    public boolean isActive(int index) {
        return ((Boolean[])this.isActive.getValue())[index];
    }

    public boolean isAnyActive() {
        for (int i = 0; i < this.numProcessors; ++i) {
            if (!this.isActive(i)) continue;
            return true;
        }
        return false;
    }

    public int getTotalActive() {
        int count = 0;
        for (int i = 0; i < this.numProcessors; ++i) {
            if (!this.isActive(i)) continue;
            ++count;
        }
        return count;
    }

    public void setShouldKeepProgress(boolean should, int index) {
        this.shouldKeepProgress.setValue(should, index);
    }

    public boolean canProcessItem2ItemRecipe(int procNumber, RecipeType<?> typeIn) {
        ComponentGasHandlerMulti handler;
        boolean gasBiRoom;
        ComponentFluidHandlerMulti handler2;
        boolean fluidBiRoom;
        boolean itemBiRoom;
        int locCap;
        Item2ItemRecipe locRecipe;
        if (!this.checkExistingRecipe(procNumber)) {
            this.setShouldKeepProgress(false, procNumber);
            this.operatingTicks.setValue(0.0, procNumber);
            locRecipe = (Item2ItemRecipe)this.getRecipe(typeIn, procNumber);
            if (locRecipe == null) {
                return false;
            }
        } else {
            this.setShouldKeepProgress(true, procNumber);
            locRecipe = (Item2ItemRecipe)this.activeRecipies[procNumber];
        }
        this.setRecipe(locRecipe, procNumber);
        this.requiredTicks.setValue(locRecipe.getTicks(), procNumber);
        this.usage.setValue(locRecipe.getUsagePerTick(), procNumber);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.holder.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsage(procNumber)) {
            return false;
        }
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        ItemStack output = inv.getOutputContents().get(procNumber);
        ItemStack result = locRecipe.getItemRecipeOutput();
        boolean isEmpty = output.m_41619_();
        if (!isEmpty && !ItemUtils.testItems(output.m_41720_(), result.m_41720_())) {
            return false;
        }
        int n = locCap = isEmpty ? 64 : output.m_41741_();
        if (locCap < output.m_41613_() + result.m_41613_()) {
            return false;
        }
        if (locRecipe.hasItemBiproducts() && !(itemBiRoom = ComponentProcessor.roomInItemBiSlots(inv.getBiprodsForProcessor(procNumber), locRecipe.getFullItemBiStacks()))) {
            return false;
        }
        if (locRecipe.hasFluidBiproducts() && !(fluidBiRoom = ComponentProcessor.roomInBiproductFluidTanks((handler2 = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler)).getOutputTanks(), locRecipe.getFullFluidBiStacks()))) {
            return false;
        }
        return !locRecipe.hasGasBiproducts() || (gasBiRoom = ComponentProcessor.roomInBiproductGasTanks((handler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler)).getOutputTanks(), locRecipe.getFullGasBiStacks()));
    }

    public boolean canProcessFluid2ItemRecipe(int procNumber, RecipeType<?> typeIn) {
        ComponentGasHandlerMulti handler;
        boolean gasBiRoom;
        ComponentFluidHandlerMulti handler2;
        boolean fluidBiRoom;
        boolean itemBiRoom;
        int locCap;
        Fluid2ItemRecipe locRecipe;
        if (!this.checkExistingRecipe(procNumber)) {
            this.setShouldKeepProgress(false, procNumber);
            this.operatingTicks.setValue(0.0, procNumber);
            locRecipe = (Fluid2ItemRecipe)this.getRecipe(typeIn, procNumber);
            if (locRecipe == null) {
                return false;
            }
        } else {
            this.setShouldKeepProgress(true, procNumber);
            locRecipe = (Fluid2ItemRecipe)this.activeRecipies[procNumber];
        }
        this.setRecipe(locRecipe, procNumber);
        this.requiredTicks.setValue(locRecipe.getTicks(), procNumber);
        this.usage.setValue(locRecipe.getUsagePerTick(), procNumber);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.holder.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsage(procNumber)) {
            return false;
        }
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        ItemStack output = inv.getOutputContents().get(procNumber);
        ItemStack result = locRecipe.getItemRecipeOutput();
        boolean isEmpty = output.m_41619_();
        if (!isEmpty && !ItemUtils.testItems(output.m_41720_(), result.m_41720_())) {
            return false;
        }
        int n = locCap = isEmpty ? 64 : output.m_41741_();
        if (locCap < output.m_41613_() + result.m_41613_()) {
            return false;
        }
        if (locRecipe.hasItemBiproducts() && !(itemBiRoom = ComponentProcessor.roomInItemBiSlots(inv.getBiprodsForProcessor(procNumber), locRecipe.getFullItemBiStacks()))) {
            return false;
        }
        if (locRecipe.hasFluidBiproducts() && !(fluidBiRoom = ComponentProcessor.roomInBiproductFluidTanks((handler2 = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler)).getOutputTanks(), locRecipe.getFullFluidBiStacks()))) {
            return false;
        }
        return !locRecipe.hasGasBiproducts() || (gasBiRoom = ComponentProcessor.roomInBiproductGasTanks((handler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler)).getOutputTanks(), locRecipe.getFullGasBiStacks()));
    }

    public boolean canProcessFluid2FluidRecipe(int procNumber, RecipeType<?> typeIn) {
        ComponentGasHandlerMulti gasHandler;
        boolean gasBiRoom;
        boolean fluidBiRoom;
        ComponentInventory inv;
        boolean itemBiRoom;
        Fluid2FluidRecipe locRecipe;
        if (!this.checkExistingRecipe(procNumber)) {
            this.setShouldKeepProgress(false, procNumber);
            this.operatingTicks.setValue(0.0, procNumber);
            locRecipe = (Fluid2FluidRecipe)this.getRecipe(typeIn, procNumber);
            if (locRecipe == null) {
                return false;
            }
        } else {
            this.setShouldKeepProgress(true, procNumber);
            locRecipe = (Fluid2FluidRecipe)this.activeRecipies[procNumber];
        }
        this.setRecipe(locRecipe, procNumber);
        this.requiredTicks.setValue(locRecipe.getTicks(), procNumber);
        this.usage.setValue(locRecipe.getUsagePerTick(), procNumber);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.holder.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsage(procNumber)) {
            return false;
        }
        ComponentFluidHandlerMulti handler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        int amtAccepted = handler.getOutputTanks()[0].fill(locRecipe.getFluidRecipeOutput(), IFluidHandler.FluidAction.SIMULATE);
        if (amtAccepted < locRecipe.getFluidRecipeOutput().getAmount()) {
            return false;
        }
        if (locRecipe.hasItemBiproducts() && !(itemBiRoom = ComponentProcessor.roomInItemBiSlots((inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory)).getBiprodsForProcessor(procNumber), locRecipe.getFullItemBiStacks()))) {
            return false;
        }
        if (locRecipe.hasFluidBiproducts() && !(fluidBiRoom = ComponentProcessor.roomInBiproductFluidTanks(handler.getOutputTanks(), locRecipe.getFullFluidBiStacks()))) {
            return false;
        }
        return !locRecipe.hasGasBiproducts() || (gasBiRoom = ComponentProcessor.roomInBiproductGasTanks((gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler)).getOutputTanks(), locRecipe.getFullGasBiStacks()));
    }

    public boolean canProcessItem2FluidRecipe(int procNumber, RecipeType<?> typeIn) {
        ComponentGasHandlerMulti gasHandler;
        boolean gasBiRoom;
        boolean fluidBiRoom;
        ComponentInventory inv;
        boolean itemBiRoom;
        Item2FluidRecipe locRecipe;
        if (!this.checkExistingRecipe(procNumber)) {
            this.setShouldKeepProgress(false, procNumber);
            this.operatingTicks.setValue(0.0, procNumber);
            locRecipe = (Item2FluidRecipe)this.getRecipe(typeIn, procNumber);
            if (locRecipe == null) {
                return false;
            }
        } else {
            this.setShouldKeepProgress(true, procNumber);
            locRecipe = (Item2FluidRecipe)this.activeRecipies[procNumber];
        }
        this.setRecipe(locRecipe, procNumber);
        this.requiredTicks.setValue(locRecipe.getTicks(), procNumber);
        this.usage.setValue(locRecipe.getUsagePerTick(), procNumber);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.holder.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsage(procNumber)) {
            return false;
        }
        ComponentFluidHandlerMulti handler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        int amtAccepted = handler.getOutputTanks()[0].fill(locRecipe.getFluidRecipeOutput(), IFluidHandler.FluidAction.SIMULATE);
        if (amtAccepted < locRecipe.getFluidRecipeOutput().getAmount()) {
            return false;
        }
        if (locRecipe.hasItemBiproducts() && !(itemBiRoom = ComponentProcessor.roomInItemBiSlots((inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory)).getBiprodsForProcessor(procNumber), locRecipe.getFullItemBiStacks()))) {
            return false;
        }
        if (locRecipe.hasFluidBiproducts() && !(fluidBiRoom = ComponentProcessor.roomInBiproductFluidTanks(handler.getOutputTanks(), locRecipe.getFullFluidBiStacks()))) {
            return false;
        }
        return !locRecipe.hasGasBiproducts() || (gasBiRoom = ComponentProcessor.roomInBiproductGasTanks((gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler)).getOutputTanks(), locRecipe.getFullGasBiStacks()));
    }

    public boolean canProcessFluidItem2FluidRecipe(int procNumber, RecipeType<?> typeIn) {
        ComponentGasHandlerMulti gasHandler;
        boolean gasBiRoom;
        boolean fluidBiRoom;
        ComponentInventory inv;
        boolean itemBiRoom;
        FluidItem2FluidRecipe locRecipe;
        if (!this.checkExistingRecipe(procNumber)) {
            this.setShouldKeepProgress(false, procNumber);
            this.operatingTicks.setValue(0.0, procNumber);
            locRecipe = (FluidItem2FluidRecipe)this.getRecipe(typeIn, procNumber);
            if (locRecipe == null) {
                return false;
            }
        } else {
            this.setShouldKeepProgress(true, procNumber);
            locRecipe = (FluidItem2FluidRecipe)this.activeRecipies[procNumber];
        }
        this.setRecipe(locRecipe, procNumber);
        this.requiredTicks.setValue(locRecipe.getTicks(), procNumber);
        this.usage.setValue(locRecipe.getUsagePerTick(), procNumber);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.holder.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsage(procNumber)) {
            return false;
        }
        ComponentFluidHandlerMulti handler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        int amtAccepted = handler.getOutputTanks()[0].fill(locRecipe.getFluidRecipeOutput(), IFluidHandler.FluidAction.SIMULATE);
        if (amtAccepted < locRecipe.getFluidRecipeOutput().getAmount()) {
            return false;
        }
        if (locRecipe.hasItemBiproducts() && !(itemBiRoom = ComponentProcessor.roomInItemBiSlots((inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory)).getBiprodsForProcessor(procNumber), locRecipe.getFullItemBiStacks()))) {
            return false;
        }
        if (locRecipe.hasFluidBiproducts() && !(fluidBiRoom = ComponentProcessor.roomInBiproductFluidTanks(handler.getOutputTanks(), locRecipe.getFullFluidBiStacks()))) {
            return false;
        }
        return !locRecipe.hasGasBiproducts() || (gasBiRoom = ComponentProcessor.roomInBiproductGasTanks((gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler)).getOutputTanks(), locRecipe.getFullGasBiStacks()));
    }

    public boolean canProcessFluidItem2ItemRecipe(int procNumber, RecipeType<?> typeIn) {
        ComponentGasHandlerMulti gasHandler;
        boolean gasBiRoom;
        ComponentFluidHandlerMulti handler;
        boolean fluidBiRoom;
        boolean itemBiRoom;
        int locCap;
        FluidItem2ItemRecipe locRecipe;
        if (!this.checkExistingRecipe(procNumber)) {
            this.setShouldKeepProgress(false, procNumber);
            this.operatingTicks.setValue(0.0, procNumber);
            locRecipe = (FluidItem2ItemRecipe)this.getRecipe(typeIn, procNumber);
            if (locRecipe == null) {
                return false;
            }
        } else {
            this.setShouldKeepProgress(true, procNumber);
            locRecipe = (FluidItem2ItemRecipe)this.activeRecipies[procNumber];
        }
        this.setRecipe(locRecipe, procNumber);
        this.requiredTicks.setValue(locRecipe.getTicks(), procNumber);
        this.usage.setValue(locRecipe.getUsagePerTick(), procNumber);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.holder.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsage(procNumber)) {
            return false;
        }
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        ItemStack output = inv.getOutputContents().get(procNumber);
        ItemStack result = locRecipe.getItemRecipeOutput();
        boolean isEmpty = output.m_41619_();
        if (!isEmpty && !ItemUtils.testItems(output.m_41720_(), result.m_41720_())) {
            return false;
        }
        int n = locCap = isEmpty ? 64 : output.m_41741_();
        if (locCap < output.m_41613_() + result.m_41613_()) {
            return false;
        }
        if (locRecipe.hasItemBiproducts() && !(itemBiRoom = ComponentProcessor.roomInItemBiSlots(inv.getBiprodsForProcessor(procNumber), locRecipe.getFullItemBiStacks()))) {
            return false;
        }
        if (locRecipe.hasFluidBiproducts() && !(fluidBiRoom = ComponentProcessor.roomInBiproductFluidTanks((handler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler)).getOutputTanks(), locRecipe.getFullFluidBiStacks()))) {
            return false;
        }
        return !locRecipe.hasGasBiproducts() || (gasBiRoom = ComponentProcessor.roomInBiproductGasTanks((gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler)).getOutputTanks(), locRecipe.getFullGasBiStacks()));
    }

    public boolean canProcessFluid2GasRecipe(int procNumber, RecipeType<?> typeIn) {
        boolean gasBiRoom;
        boolean fluidBiRoom;
        ComponentInventory inv;
        boolean itemBiRoom;
        Fluid2GasRecipe locRecipe;
        if (!this.checkExistingRecipe(procNumber)) {
            this.setShouldKeepProgress(false, procNumber);
            this.operatingTicks.setValue(0.0, procNumber);
            locRecipe = (Fluid2GasRecipe)this.getRecipe(typeIn, procNumber);
            if (locRecipe == null) {
                return false;
            }
        } else {
            this.setShouldKeepProgress(true, procNumber);
            locRecipe = (Fluid2GasRecipe)this.activeRecipies[procNumber];
        }
        this.setRecipe(locRecipe, procNumber);
        this.requiredTicks.setValue(locRecipe.getTicks(), procNumber);
        this.usage.setValue(locRecipe.getUsagePerTick(), procNumber);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.holder.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsage(procNumber)) {
            return false;
        }
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler);
        ComponentFluidHandlerMulti fluidHandler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        double amtAccepted = gasHandler.getOutputTanks()[0].fill(locRecipe.getGasRecipeOutput(), GasAction.SIMULATE);
        if (amtAccepted < (double)locRecipe.getGasRecipeOutput().getAmount()) {
            return false;
        }
        if (locRecipe.hasItemBiproducts() && !(itemBiRoom = ComponentProcessor.roomInItemBiSlots((inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory)).getBiprodsForProcessor(procNumber), locRecipe.getFullItemBiStacks()))) {
            return false;
        }
        if (locRecipe.hasFluidBiproducts() && !(fluidBiRoom = ComponentProcessor.roomInBiproductFluidTanks(fluidHandler.getOutputTanks(), locRecipe.getFullFluidBiStacks()))) {
            return false;
        }
        return !locRecipe.hasGasBiproducts() || (gasBiRoom = ComponentProcessor.roomInBiproductGasTanks(gasHandler.getOutputTanks(), locRecipe.getFullGasBiStacks()));
    }

    public boolean canProcessFluidItem2GasRecipe(int procNumber, RecipeType<?> typeIn) {
        boolean gasBiRoom;
        ComponentFluidHandlerMulti fluidHandler;
        boolean fluidBiRoom;
        ComponentInventory inv;
        boolean itemBiRoom;
        FluidItem2GasRecipe locRecipe;
        if (!this.checkExistingRecipe(procNumber)) {
            this.setShouldKeepProgress(false, procNumber);
            this.operatingTicks.setValue(0.0, procNumber);
            locRecipe = (FluidItem2GasRecipe)this.getRecipe(typeIn, procNumber);
            if (locRecipe == null) {
                return false;
            }
        } else {
            this.setShouldKeepProgress(true, procNumber);
            locRecipe = (FluidItem2GasRecipe)this.activeRecipies[procNumber];
        }
        this.setRecipe(locRecipe, procNumber);
        this.requiredTicks.setValue(locRecipe.getTicks(), procNumber);
        this.usage.setValue(locRecipe.getUsagePerTick(), procNumber);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.holder.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsage(procNumber)) {
            return false;
        }
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler);
        double amtAccepted = gasHandler.getOutputTanks()[0].fill(locRecipe.getGasRecipeOutput(), GasAction.SIMULATE);
        if (amtAccepted < (double)locRecipe.getGasRecipeOutput().getAmount()) {
            return false;
        }
        if (locRecipe.hasItemBiproducts() && !(itemBiRoom = ComponentProcessor.roomInItemBiSlots((inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory)).getBiprodsForProcessor(procNumber), locRecipe.getFullItemBiStacks()))) {
            return false;
        }
        if (locRecipe.hasFluidBiproducts() && !(fluidBiRoom = ComponentProcessor.roomInBiproductFluidTanks((fluidHandler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler)).getOutputTanks(), locRecipe.getFullFluidBiStacks()))) {
            return false;
        }
        return !locRecipe.hasGasBiproducts() || (gasBiRoom = ComponentProcessor.roomInBiproductGasTanks(gasHandler.getOutputTanks(), locRecipe.getFullGasBiStacks()));
    }

    public void processItem2ItemRecipe(int procNumber) {
        int i;
        Object[] outTanks;
        IComponent handler;
        ItemStack stack;
        if (this.getRecipe(procNumber) == null) {
            return;
        }
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        Item2ItemRecipe locRecipe = (Item2ItemRecipe)this.getRecipe(procNumber);
        List<Integer> slotOrientation = locRecipe.getItemArrangment(procNumber);
        if (locRecipe.hasItemBiproducts()) {
            List<ProbableItem> itemBi = locRecipe.getItemBiproducts();
            int index = 0;
            for (int slot : inv.getBiprodSlotsForProcessor(procNumber)) {
                stack = inv.m_8020_(slot);
                if (stack.m_41619_()) {
                    inv.m_6836_(slot, itemBi.get(index).roll().m_41777_());
                    continue;
                }
                stack.m_41769_(itemBi.get(index).roll().m_41613_());
                inv.m_6836_(slot, stack);
            }
        }
        if (locRecipe.hasFluidBiproducts()) {
            handler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
            List<ProbableFluid> fluidBi = locRecipe.getFluidBiproducts();
            outTanks = ((ComponentFluidHandlerMulti)handler).getOutputTanks();
            for (i = 0; i < fluidBi.size(); ++i) {
                outTanks[i].fill(fluidBi.get(i).roll(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (locRecipe.hasGasBiproducts()) {
            handler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler);
            List<ProbableGas> gasBi = locRecipe.getGasBiproducts();
            outTanks = ((ComponentGasHandlerMulti)handler).getOutputTanks();
            for (i = 0; i < gasBi.size(); ++i) {
                ((GasTank)((Object)outTanks[i])).fill(gasBi.get(i).roll(), GasAction.EXECUTE);
            }
        }
        int outputSlot = inv.getOutputSlots().get(procNumber);
        if (inv.getOutputContents().get(procNumber).m_41619_()) {
            inv.m_6836_(outputSlot, locRecipe.getItemRecipeOutput().m_41777_());
        } else {
            ItemStack stack2 = inv.getOutputContents().get(procNumber);
            stack2.m_41769_(locRecipe.getItemRecipeOutput().m_41613_());
            inv.m_6836_(outputSlot, stack2);
        }
        List<Integer> inputs = inv.getInputSlotsForProcessor(procNumber);
        for (int i2 = 0; i2 < inputs.size(); ++i2) {
            int index = inputs.get(slotOrientation.get(i2));
            stack = inv.m_8020_(index);
            stack.m_41774_(locRecipe.getCountedIngredients().get(i2).getStackSize());
            inv.m_6836_(index, stack);
        }
        this.dispenseExperience(inv, locRecipe.getXp());
        this.setChanged();
    }

    public void processFluidItem2FluidRecipe(int procNumber) {
        if (this.getRecipe(procNumber) == null) {
            return;
        }
        FluidItem2FluidRecipe locRecipe = (FluidItem2FluidRecipe)this.getRecipe(procNumber);
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        ComponentFluidHandlerMulti handler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        List<Integer> slotOrientation = locRecipe.getItemArrangment(procNumber);
        if (locRecipe.hasItemBiproducts()) {
            List<ProbableItem> itemBi = locRecipe.getItemBiproducts();
            int index = 0;
            for (int slot : inv.getBiprodSlotsForProcessor(procNumber)) {
                ItemStack stack = inv.m_8020_(slot);
                if (stack.m_41619_()) {
                    inv.m_6836_(slot, itemBi.get(index).roll().m_41777_());
                    continue;
                }
                stack.m_41769_(itemBi.get(index).roll().m_41613_());
                inv.m_6836_(slot, stack);
            }
        }
        if (locRecipe.hasFluidBiproducts()) {
            List<ProbableFluid> fluidBi = locRecipe.getFluidBiproducts();
            PropertyFluidTank[] outTanks = handler.getOutputTanks();
            for (int i = 0; i < fluidBi.size(); ++i) {
                outTanks[i + 1].fill(fluidBi.get(i).roll(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (locRecipe.hasGasBiproducts()) {
            ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler);
            List<ProbableGas> gasBi = locRecipe.getGasBiproducts();
            PropertyGasTank[] outTanks = gasHandler.getOutputTanks();
            for (int i = 0; i < gasBi.size(); ++i) {
                outTanks[i].fill(gasBi.get(i).roll(), GasAction.EXECUTE);
            }
        }
        handler.getOutputTanks()[0].fill(locRecipe.getFluidRecipeOutput(), IFluidHandler.FluidAction.EXECUTE);
        List<Integer> inputs = inv.getInputSlotsForProcessor(procNumber);
        for (int i = 0; i < inputs.size(); ++i) {
            int index = inputs.get(slotOrientation.get(i));
            ItemStack stack = inv.m_8020_(index);
            stack.m_41774_(locRecipe.getCountedIngredients().get(i).getStackSize());
            inv.m_6836_(index, stack);
        }
        PropertyFluidTank[] tanks = handler.getInputTanks();
        List<FluidIngredient> fluidIngs = locRecipe.getFluidIngredients();
        List<Integer> tankOrientation = locRecipe.getFluidArrangement();
        for (int i = 0; i < handler.tankCount(true); ++i) {
            tanks[tankOrientation.get(i)].drain(fluidIngs.get(i).getFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.dispenseExperience(inv, locRecipe.getXp());
        this.setChanged();
    }

    public void processFluidItem2ItemRecipe(int procNumber) {
        if (this.getRecipe(procNumber) == null) {
            return;
        }
        FluidItem2ItemRecipe locRecipe = (FluidItem2ItemRecipe)this.getRecipe(procNumber);
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        ComponentFluidHandlerMulti handler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        List<Integer> slotOrientation = locRecipe.getItemArrangment(procNumber);
        if (locRecipe.hasItemBiproducts()) {
            List<ProbableItem> itemBi = locRecipe.getItemBiproducts();
            int index = 0;
            for (int slot : inv.getBiprodSlotsForProcessor(procNumber)) {
                ItemStack stack = inv.m_8020_(slot);
                if (stack.m_41619_()) {
                    inv.m_6836_(slot, itemBi.get(index).roll().m_41777_());
                    continue;
                }
                stack.m_41769_(itemBi.get(index).roll().m_41613_());
                inv.m_6836_(slot, stack);
            }
        }
        if (locRecipe.hasFluidBiproducts()) {
            List<ProbableFluid> fluidBi = locRecipe.getFluidBiproducts();
            PropertyFluidTank[] outTanks = handler.getOutputTanks();
            for (int i = 0; i < fluidBi.size(); ++i) {
                outTanks[i].fill(fluidBi.get(i).roll(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (locRecipe.hasGasBiproducts()) {
            ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler);
            List<ProbableGas> gasBi = locRecipe.getGasBiproducts();
            PropertyGasTank[] outTanks = gasHandler.getOutputTanks();
            for (int i = 0; i < gasBi.size(); ++i) {
                outTanks[i].fill(gasBi.get(i).roll(), GasAction.EXECUTE);
            }
        }
        if (inv.getOutputContents().get(procNumber).m_41619_()) {
            inv.m_6836_(inv.getOutputSlots().get(procNumber), locRecipe.getItemRecipeOutput().m_41777_());
        } else {
            inv.getOutputContents().get(procNumber).m_41769_(locRecipe.getItemRecipeOutput().m_41613_());
        }
        List<Integer> inputs = inv.getInputSlotsForProcessor(procNumber);
        for (int i = 0; i < inputs.size(); ++i) {
            int index = inputs.get(slotOrientation.get(i));
            ItemStack stack = inv.m_8020_(index);
            stack.m_41774_(locRecipe.getCountedIngredients().get(i).getStackSize());
            inv.m_6836_(index, stack);
        }
        PropertyFluidTank[] tanks = handler.getInputTanks();
        List<FluidIngredient> fluidIngs = locRecipe.getFluidIngredients();
        List<Integer> tankOrientation = locRecipe.getFluidArrangement();
        for (int i = 0; i < handler.tankCount(true); ++i) {
            tanks[tankOrientation.get(i)].drain(fluidIngs.get(i).getFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.dispenseExperience(inv, locRecipe.getXp());
        this.setChanged();
    }

    public void processFluid2ItemRecipe(int procNumber) {
        int i;
        if (this.getRecipe(procNumber) == null) {
            return;
        }
        Fluid2ItemRecipe locRecipe = (Fluid2ItemRecipe)this.getRecipe(procNumber);
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        ComponentFluidHandlerMulti handler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        if (locRecipe.hasItemBiproducts()) {
            List<ProbableItem> itemBi = locRecipe.getItemBiproducts();
            int index = 0;
            for (int slot : inv.getBiprodSlotsForProcessor(procNumber)) {
                ItemStack stack = inv.m_8020_(slot);
                if (stack.m_41619_()) {
                    inv.m_6836_(slot, itemBi.get(index).roll().m_41777_());
                    continue;
                }
                stack.m_41769_(itemBi.get(index).roll().m_41613_());
                inv.m_6836_(slot, stack);
            }
        }
        if (locRecipe.hasFluidBiproducts()) {
            List<ProbableFluid> fluidBi = locRecipe.getFluidBiproducts();
            PropertyFluidTank[] outTanks = handler.getOutputTanks();
            for (int i2 = 0; i2 < fluidBi.size(); ++i2) {
                outTanks[i2].fill(fluidBi.get(i2).roll(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (locRecipe.hasGasBiproducts()) {
            ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler);
            List<ProbableGas> gasBi = locRecipe.getGasBiproducts();
            PropertyGasTank[] outTanks = gasHandler.getOutputTanks();
            for (i = 0; i < gasBi.size(); ++i) {
                outTanks[i].fill(gasBi.get(i).roll(), GasAction.EXECUTE);
            }
        }
        if (inv.getOutputContents().get(procNumber).m_41619_()) {
            inv.m_6836_(inv.getOutputSlots().get(procNumber), locRecipe.getItemRecipeOutput().m_41777_());
        } else {
            inv.getOutputContents().get(procNumber).m_41769_(locRecipe.getItemRecipeOutput().m_41613_());
        }
        PropertyFluidTank[] tanks = handler.getInputTanks();
        List<FluidIngredient> fluidIngs = locRecipe.getFluidIngredients();
        List<Integer> tankOrientation = locRecipe.getFluidArrangement();
        for (i = 0; i < handler.tankCount(true); ++i) {
            tanks[tankOrientation.get(i)].drain(fluidIngs.get(i).getFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.dispenseExperience(inv, locRecipe.getXp());
        this.setChanged();
    }

    public void processFluid2FluidRecipe(int procNumber) {
        int i;
        if (this.getRecipe(procNumber) == null) {
            return;
        }
        Fluid2FluidRecipe locRecipe = (Fluid2FluidRecipe)this.getRecipe(procNumber);
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        ComponentFluidHandlerMulti handler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        if (locRecipe.hasItemBiproducts()) {
            List<ProbableItem> itemBi = locRecipe.getItemBiproducts();
            int index = 0;
            for (int slot : inv.getBiprodSlotsForProcessor(procNumber)) {
                ItemStack stack = inv.m_8020_(slot);
                if (stack.m_41619_()) {
                    inv.m_6836_(slot, itemBi.get(index).roll().m_41777_());
                    continue;
                }
                stack.m_41769_(itemBi.get(index).roll().m_41613_());
                inv.m_6836_(slot, stack);
            }
        }
        if (locRecipe.hasFluidBiproducts()) {
            List<ProbableFluid> fluidBi = locRecipe.getFluidBiproducts();
            PropertyFluidTank[] outTanks = handler.getOutputTanks();
            for (int i2 = 0; i2 < fluidBi.size(); ++i2) {
                outTanks[i2 + 1].fill(fluidBi.get(i2).roll(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (locRecipe.hasGasBiproducts()) {
            ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler);
            List<ProbableGas> gasBi = locRecipe.getGasBiproducts();
            PropertyGasTank[] outTanks = gasHandler.getOutputTanks();
            for (i = 0; i < gasBi.size(); ++i) {
                outTanks[i].fill(gasBi.get(i).roll(), GasAction.EXECUTE);
            }
        }
        handler.getOutputTanks()[0].fill(locRecipe.getFluidRecipeOutput(), IFluidHandler.FluidAction.EXECUTE);
        PropertyFluidTank[] tanks = handler.getInputTanks();
        List<FluidIngredient> fluidIngs = locRecipe.getFluidIngredients();
        List<Integer> tankOrientation = locRecipe.getFluidArrangement();
        for (i = 0; i < handler.tankCount(true); ++i) {
            tanks[tankOrientation.get(i)].drain(fluidIngs.get(i).getFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.dispenseExperience(inv, locRecipe.getXp());
        this.setChanged();
    }

    public void processFluid2GasRecipe(int procNumber) {
        if (this.getRecipe(procNumber) == null) {
            return;
        }
        Fluid2GasRecipe locRecipe = (Fluid2GasRecipe)this.getRecipe(procNumber);
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler);
        ComponentFluidHandlerMulti fluidHandler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        if (locRecipe.hasItemBiproducts()) {
            List<ProbableItem> itemBi = locRecipe.getItemBiproducts();
            int index = 0;
            for (int slot : inv.getBiprodSlotsForProcessor(procNumber)) {
                ItemStack stack = inv.m_8020_(slot);
                if (stack.m_41619_()) {
                    inv.m_6836_(slot, itemBi.get(index).roll().m_41777_());
                    continue;
                }
                stack.m_41769_(itemBi.get(index).roll().m_41613_());
                inv.m_6836_(slot, stack);
            }
        }
        if (locRecipe.hasFluidBiproducts()) {
            List<ProbableFluid> fluidBi = locRecipe.getFluidBiproducts();
            PropertyFluidTank[] outTanks = fluidHandler.getOutputTanks();
            for (int i = 0; i < fluidBi.size(); ++i) {
                outTanks[i + 1].fill(fluidBi.get(i).roll(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (locRecipe.hasGasBiproducts()) {
            List<ProbableGas> gasBi = locRecipe.getGasBiproducts();
            PropertyGasTank[] outTanks = gasHandler.getOutputTanks();
            for (int i = 0; i < gasBi.size(); ++i) {
                outTanks[i + 1].fill(gasBi.get(i).roll(), GasAction.EXECUTE);
            }
        }
        gasHandler.getOutputTanks()[0].fill(locRecipe.getGasRecipeOutput(), GasAction.EXECUTE);
        PropertyFluidTank[] tanks = fluidHandler.getInputTanks();
        List<FluidIngredient> fluidIngs = locRecipe.getFluidIngredients();
        List<Integer> tankOrientation = locRecipe.getFluidArrangement();
        for (int i = 0; i < fluidHandler.tankCount(true); ++i) {
            tanks[tankOrientation.get(i)].drain(fluidIngs.get(i).getFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.dispenseExperience(inv, locRecipe.getXp());
        this.setChanged();
    }

    public void processFluidItem2GasRecipe(int procNumber) {
        if (this.getRecipe(procNumber) == null) {
            return;
        }
        FluidItem2GasRecipe locRecipe = (FluidItem2GasRecipe)this.getRecipe(procNumber);
        ComponentInventory inv = (ComponentInventory)this.holder.getComponent(IComponentType.Inventory);
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.holder.getComponent(IComponentType.GasHandler);
        ComponentFluidHandlerMulti fluidHandler = (ComponentFluidHandlerMulti)this.holder.getComponent(IComponentType.FluidHandler);
        List<Integer> slotOrientation = locRecipe.getItemArrangment(procNumber);
        if (locRecipe.hasItemBiproducts()) {
            List<ProbableItem> itemBi = locRecipe.getItemBiproducts();
            int index = 0;
            for (int slot : inv.getBiprodSlotsForProcessor(procNumber)) {
                ItemStack stack = inv.m_8020_(slot);
                if (stack.m_41619_()) {
                    inv.m_6836_(slot, itemBi.get(index).roll().m_41777_());
                    continue;
                }
                stack.m_41769_(itemBi.get(index).roll().m_41613_());
                inv.m_6836_(slot, stack);
            }
        }
        if (locRecipe.hasFluidBiproducts()) {
            List<ProbableFluid> fluidBi = locRecipe.getFluidBiproducts();
            PropertyFluidTank[] outTanks = fluidHandler.getOutputTanks();
            for (int i = 0; i < fluidBi.size(); ++i) {
                outTanks[i + 1].fill(fluidBi.get(i).roll(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (locRecipe.hasGasBiproducts()) {
            List<ProbableGas> gasBi = locRecipe.getGasBiproducts();
            PropertyGasTank[] outTanks = gasHandler.getOutputTanks();
            for (int i = 0; i < gasBi.size(); ++i) {
                outTanks[i].fill(gasBi.get(i).roll(), GasAction.EXECUTE);
            }
        }
        gasHandler.getOutputTanks()[0].fill(locRecipe.getGasRecipeOutput(), GasAction.EXECUTE);
        List<Integer> inputs = inv.getInputSlotsForProcessor(procNumber);
        for (int i = 0; i < inputs.size(); ++i) {
            int index = inputs.get(slotOrientation.get(i));
            ItemStack stack = inv.m_8020_(index);
            stack.m_41774_(locRecipe.getCountedIngredients().get(i).getStackSize());
            inv.m_6836_(index, stack);
        }
        PropertyFluidTank[] tanks = fluidHandler.getInputTanks();
        List<FluidIngredient> fluidIngs = locRecipe.getFluidIngredients();
        List<Integer> tankOrientation = locRecipe.getFluidArrangement();
        for (int i = 0; i < fluidHandler.tankCount(true); ++i) {
            tanks[tankOrientation.get(i)].drain(fluidIngs.get(i).getFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.dispenseExperience(inv, locRecipe.getXp());
        this.setChanged();
    }

    public void dispenseExperience(ComponentInventory inv, double experience) {
        this.storedXp += experience;
        for (ItemStack stack : inv.getUpgradeContents()) {
            if (stack.m_41619_()) continue;
            ItemUpgrade upgrade = (ItemUpgrade)stack.m_41720_();
            if (upgrade.subtype != SubtypeItemUpgrade.experience) continue;
            CompoundTag tag = stack.m_41784_();
            tag.m_128347_("xp", tag.m_128459_("xp") + this.getStoredXp());
            this.setStoredXp(0.0);
            break;
        }
    }

    public static boolean roomInItemBiSlots(List<ItemStack> slots, ItemStack[] biproducts) {
        for (int i = 0; i < slots.size(); ++i) {
            ItemStack slotStack = slots.get(i);
            ItemStack biStack = biproducts[Math.min(i, biproducts.length - 1)];
            if (slotStack.m_41619_()) continue;
            if (slotStack.m_41613_() + biStack.m_41613_() > slotStack.m_41741_()) {
                return false;
            }
            if (ItemUtils.testItems(slotStack.m_41720_(), biStack.m_41720_())) continue;
            return false;
        }
        return true;
    }

    public static boolean roomInBiproductFluidTanks(FluidTank[] tanks, FluidStack[] stacks) {
        for (int i = 1; i < tanks.length; ++i) {
            FluidTank tank = tanks[i];
            FluidStack stack = stacks[Math.min(i, stacks.length - 1)];
            int amtTaken = tank.fill(stack, IFluidHandler.FluidAction.SIMULATE);
            if (amtTaken >= stack.getAmount()) continue;
            return false;
        }
        return true;
    }

    public static boolean roomInBiproductGasTanks(GasTank[] tanks, GasStack[] stacks) {
        for (int i = 1; i < tanks.length; ++i) {
            GasTank tank = tanks[i];
            GasStack stack = stacks[Math.min(i, stacks.length - 1)];
            double amtTaken = tank.fill(stack, GasAction.SIMULATE);
            if (!(amtTaken < (double)stack.getAmount())) continue;
            return false;
        }
        return true;
    }

    public boolean checkExistingRecipe(int index) {
        if (this.activeRecipies[index] != null) {
            return this.activeRecipies[index].matchesRecipe(this, index);
        }
        return false;
    }

    @Nullable
    public VoltaicRecipe getRecipe(RecipeType<?> typeIn, int index) {
        if (this.cachedRecipes.isEmpty()) {
            this.cachedRecipes = VoltaicRecipe.findRecipesbyType(typeIn, this.getHolder().m_58904_());
        }
        return VoltaicRecipe.getRecipe(this, this.cachedRecipes, index);
    }

    public void setChanged() {
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        if (inv.getUpgradeContents().size() > 0 && (slot >= inv.getUpgradeSlotStartIndex() || slot == -1)) {
            this.operatingSpeed.setValue(1.0);
            for (ItemStack stack : inv.getUpgradeContents()) {
                Item item;
                if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ItemUpgrade)) continue;
                ItemUpgrade upgrade = (ItemUpgrade)item;
                if (!upgrade.subtype.isEmpty) continue;
                for (int i = 0; i < stack.m_41613_(); ++i) {
                    if (upgrade.subtype == SubtypeItemUpgrade.basicspeed) {
                        this.operatingSpeed.setValue(Math.min((Double)this.operatingSpeed.getValue() * 1.5, Math.pow(1.5, 3.0)));
                        continue;
                    }
                    if (upgrade.subtype != SubtypeItemUpgrade.advancedspeed) continue;
                    this.operatingSpeed.setValue(Math.min((Double)this.operatingSpeed.getValue() * 2.25, Math.pow(2.25, 3.0)));
                }
            }
            if (this.holder.hasComponent(IComponentType.Electrodynamic)) {
                ComponentElectrodynamic electro = (ComponentElectrodynamic)this.holder.getComponent(IComponentType.Electrodynamic);
                electro.maxJoules(this.getTotalUsage() * (Double)this.operatingSpeed.getValue() * 10.0);
            }
        }
    }
}

