/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.types;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.types.GenericMaterialTile;

public class GenericGasTile
extends GenericMaterialTile {
    public static final int MAX_CONDENSED_AMOUNT = 10000;
    public final SingleProperty<FluidStack> condensedFluidFromGas = this.property(new SingleProperty<FluidStack>(PropertyTypes.FLUID_STACK, "condensedfluidfromgas", FluidStack.EMPTY));

    public GenericGasTile(BlockEntityType<?> tileEntityTypeIn, BlockPos worldPos, BlockState blockState) {
        super(tileEntityTypeIn, worldPos, blockState);
    }

    public BiConsumer<GasTank, GenericTile> getCondensedHandler() {
        return (tank, tile) -> {
            GasStack tankGas = tank.getGas().copy();
            tank.setGas(GasStack.EMPTY);
            if (tankGas.isEmpty()) {
                return;
            }
            Fluid condensedFluid = tankGas.getGas().getCondensedFluid();
            if (condensedFluid.m_6212_(Fluids.f_76191_)) {
                return;
            }
            tankGas.bringPressureTo(1);
            FluidStack currentCondensate = (FluidStack)this.condensedFluidFromGas.getValue();
            if (currentCondensate.getFluid().m_6212_(condensedFluid)) {
                int room = Math.max(0, 10000 - currentCondensate.getAmount());
                int taken = Math.min(room, tankGas.getAmount());
                currentCondensate.setAmount(currentCondensate.getAmount() + taken);
                this.condensedFluidFromGas.setValue(currentCondensate);
            } else {
                FluidStack newFluid = new FluidStack(condensedFluid, Math.min(tankGas.getAmount(), 10000));
                this.condensedFluidFromGas.setValue(newFluid);
            }
        };
    }
}

