/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.types;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.api.gas.IGasHandlerItem;
import voltaic.api.gas.PropertyGasTank;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.utils.IComponentFluidHandler;
import voltaic.prefab.tile.components.utils.IComponentGasHandler;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;
import voltaic.registers.VoltaicSounds;

public class GenericMaterialTile
extends GenericTile {
    public GenericMaterialTile(BlockEntityType<?> tileEntityTypeIn, BlockPos worldPos, BlockState blockState) {
        super(tileEntityTypeIn, worldPos, blockState);
    }

    @Override
    public InteractionResult use(Player player, InteractionHand handIn, BlockHitResult hit) {
        IGasHandlerItem handlerGasItem;
        ItemStack used = player.m_21120_(handIn);
        if (used.m_41619_()) {
            return super.use(player, handIn, hit);
        }
        Level world = this.m_58904_();
        IFluidHandlerItem handlerFluidItem = used.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().orElse(CapabilityUtils.EMPTY_FLUID_ITEM);
        if (handlerFluidItem != CapabilityUtils.EMPTY_FLUID_ITEM && this.hasComponent(IComponentType.FluidHandler)) {
            IComponentFluidHandler fluidHandler = (IComponentFluidHandler)this.getComponent(IComponentType.FluidHandler);
            for (PropertyFluidTank tank : fluidHandler.getInputTanks()) {
                int space = tank.getSpace();
                FluidStack containedFluid = handlerFluidItem.drain(space, IFluidHandler.FluidAction.SIMULATE);
                if (containedFluid.isEmpty()) continue;
                if (!world.f_46443_) {
                    tank.fill(containedFluid, IFluidHandler.FluidAction.EXECUTE);
                    if (!player.m_7500_()) {
                        handlerFluidItem.drain(space, IFluidHandler.FluidAction.EXECUTE);
                    }
                    world.m_5594_(null, player.m_20183_(), SoundEvents.f_11778_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_21008_(handIn, handlerFluidItem.getContainer());
                }
                return InteractionResult.CONSUME;
            }
            for (PropertyFluidTank tank : fluidHandler.getOutputTanks()) {
                FluidStack tankFluid = tank.getFluid();
                int taken = handlerFluidItem.fill(tankFluid, IFluidHandler.FluidAction.EXECUTE);
                if (taken <= 0) continue;
                if (!world.f_46443_) {
                    tank.drain(taken, IFluidHandler.FluidAction.EXECUTE);
                    world.m_5594_(null, player.m_20183_(), SoundEvents.f_11781_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_21008_(handIn, handlerFluidItem.getContainer());
                }
                return InteractionResult.CONSUME;
            }
        }
        if ((handlerGasItem = (IGasHandlerItem)used.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM)) != CapabilityUtils.EMPTY_GAS_ITEM && this.hasComponent(IComponentType.GasHandler)) {
            IComponentGasHandler gasHandler = (IComponentGasHandler)this.getComponent(IComponentType.GasHandler);
            for (PropertyGasTank tank : gasHandler.getInputTanks()) {
                int space = tank.getSpace();
                GasStack containedGas = handlerGasItem.drain(space, GasAction.SIMULATE);
                if (containedGas.isEmpty()) continue;
                if (!world.f_46443_) {
                    tank.fill(containedGas, GasAction.EXECUTE);
                    if (!player.m_7500_()) {
                        handlerGasItem.drain(space, GasAction.EXECUTE);
                    }
                    world.m_5594_(null, player.m_20183_(), (SoundEvent)VoltaicSounds.SOUND_PRESSURERELEASE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_21008_(handIn, handlerGasItem.getContainer());
                }
                return InteractionResult.CONSUME;
            }
            for (PropertyGasTank tank : gasHandler.getOutputTanks()) {
                GasStack tankGas = ((GasTank)tank).getGas();
                int taken = handlerGasItem.fill(tankGas, GasAction.EXECUTE);
                if (taken <= 0) continue;
                if (!world.f_46443_) {
                    tank.drain(taken, GasAction.EXECUTE);
                    world.m_5594_(null, player.m_20183_(), (SoundEvent)VoltaicSounds.SOUND_PRESSURERELEASE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_21008_(handIn, handlerGasItem.getContainer());
                }
                return InteractionResult.CONSUME;
            }
        }
        return super.use(player, handIn, hit);
    }
}

