/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities;

import java.util.List;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class ContainerUtils {
    static final int PLAYER_INV_Y_DEFAULT = 84;
    static final int PLAYER_INV_X_DEFAULT = 8;

    public static ItemStack handleShiftClick(List<Slot> slots, Player player, int slotIndex) {
        Slot sourceSlot = slots.get(slotIndex);
        ItemStack inputStack = sourceSlot.m_7993_();
        if (inputStack == null) {
            return null;
        }
        boolean sourceIsPlayer = sourceSlot.f_40218_ == player.m_150109_();
        ItemStack copy = inputStack.m_41777_();
        if (sourceIsPlayer) {
            if (!ContainerUtils.mergeStack(player.m_150109_(), false, sourceSlot, slots, false)) {
                return ItemStack.f_41583_;
            }
            return copy;
        }
        boolean isMachineOutput = !sourceSlot.m_5857_(inputStack);
        if (!ContainerUtils.mergeStack(player.m_150109_(), true, sourceSlot, slots, !isMachineOutput)) {
            return ItemStack.f_41583_;
        }
        return copy;
    }

    private static boolean mergeStack(Inventory playerInv, boolean mergeIntoPlayer, Slot sourceSlot, List<Slot> slots, boolean reverse) {
        Slot targetSlot;
        int idx;
        ItemStack sourceStack = sourceSlot.m_7993_();
        int originalSize = sourceStack.m_41613_();
        int len = slots.size();
        if (sourceStack.m_41753_()) {
            int n = idx = reverse ? len - 1 : 0;
            while (sourceStack.m_41613_() > 0 && (reverse ? idx >= 0 : idx < len)) {
                targetSlot = slots.get(idx);
                if (targetSlot.f_40218_ == playerInv == mergeIntoPlayer) {
                    ItemStack target = targetSlot.m_7993_();
                    if (sourceStack.m_41720_() == target.m_41720_()) {
                        int targetMax = Math.min(targetSlot.m_6641_(), target.m_41741_());
                        int toTransfer = Math.min(sourceStack.m_41613_(), targetMax - target.m_41613_());
                        if (toTransfer > 0) {
                            target.m_41764_(target.m_41613_() + toTransfer);
                            sourceStack.m_41764_(sourceStack.m_41613_() - toTransfer);
                            targetSlot.m_6654_();
                        }
                    }
                }
                if (reverse) {
                    --idx;
                    continue;
                }
                ++idx;
            }
            if (sourceStack.m_41613_() == 0) {
                sourceSlot.m_5852_(ItemStack.f_41583_);
                return true;
            }
        }
        int n = idx = reverse ? len - 1 : 0;
        while (reverse ? idx >= 0 : idx < len) {
            targetSlot = slots.get(idx);
            if (targetSlot.f_40218_ == playerInv == mergeIntoPlayer && !targetSlot.m_6657_() && targetSlot.m_5857_(sourceStack)) {
                targetSlot.m_5852_(sourceStack.m_41777_());
                sourceSlot.m_5852_(ItemStack.f_41583_);
                sourceStack.m_41764_(0);
                return true;
            }
            if (reverse) {
                --idx;
                continue;
            }
            ++idx;
        }
        if (sourceStack.m_41613_() != originalSize) {
            sourceSlot.m_6654_();
            return true;
        }
        return false;
    }
}

