/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities;

import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;

public class VoltaicTextUtils {
    public static final String GUI_BASE = "gui";
    public static final String TOOLTIP_BASE = "tooltip";
    public static final String JEI_BASE = "jei";
    public static final String GUIDEBOOK_BASE = "guidebook";
    public static final String MESSAGE_BASE = "chat";
    public static final String JEI_INFO_ITEM = "info.item";
    public static final String JEI_INFO_FLUID = "info.fluid";
    public static final String BLOCK_BASE = "block";
    public static final String GAS_BASE = "gas";
    public static final String ADVANCEMENT_BASE = "advancement";
    public static final String DIMENSION = "dimension";
    public static final String CREATIVE_TAB = "creativetab";

    public static MutableComponent tooltip(String key, Object ... additional) {
        return VoltaicTextUtils.translated(TOOLTIP_BASE, key, additional);
    }

    public static MutableComponent guidebook(String key, Object ... additional) {
        return VoltaicTextUtils.translated(GUIDEBOOK_BASE, key, additional);
    }

    public static MutableComponent gui(String key, Object ... additional) {
        return VoltaicTextUtils.translated(GUI_BASE, key, additional);
    }

    public static MutableComponent chatMessage(String key, Object ... additional) {
        return VoltaicTextUtils.translated(MESSAGE_BASE, key, additional);
    }

    public static MutableComponent jeiTranslated(String key, Object ... additional) {
        return Component.m_237110_((String)("jei." + key), (Object[])additional);
    }

    public static MutableComponent jeiItemTranslated(String key, Object ... additional) {
        return VoltaicTextUtils.jeiTranslated("info.item." + key, additional);
    }

    public static MutableComponent jeiFluidTranslated(String key, Object ... additional) {
        return VoltaicTextUtils.jeiTranslated("info.fluid." + key, additional);
    }

    public static MutableComponent block(String key, Object ... additional) {
        return VoltaicTextUtils.translated(BLOCK_BASE, key, additional);
    }

    public static MutableComponent gas(String key, Object ... additional) {
        return VoltaicTextUtils.translated(GAS_BASE, key, additional);
    }

    public static MutableComponent advancement(String key, Object ... additional) {
        return VoltaicTextUtils.translated(ADVANCEMENT_BASE, key, additional);
    }

    public static MutableComponent dimension(String key, Object ... additional) {
        return VoltaicTextUtils.translated(DIMENSION, key, additional);
    }

    public static MutableComponent dimension(ResourceKey<Level> level, Object ... additional) {
        return VoltaicTextUtils.dimension(level.m_135782_().m_135815_(), additional);
    }

    public static MutableComponent creativeTab(String key, Object ... additional) {
        return VoltaicTextUtils.translated(CREATIVE_TAB, key, additional);
    }

    public static MutableComponent translated(String base, String key, Object ... additional) {
        return Component.m_237110_((String)(base + ".voltaic." + key), (Object[])additional);
    }

    public static boolean guiExists(String key) {
        return VoltaicTextUtils.translationExists(GUI_BASE, key);
    }

    public static boolean tooltipExists(String key) {
        return VoltaicTextUtils.translationExists(TOOLTIP_BASE, key);
    }

    public static boolean dimensionExistst(String key) {
        return VoltaicTextUtils.translationExists(DIMENSION, key);
    }

    public static boolean dimensionExists(ResourceKey<Level> level) {
        return VoltaicTextUtils.dimensionExistst(level.m_135782_().m_135815_());
    }

    public static boolean translationExists(String base, String key) {
        return I18n.m_118936_((String)(base + ".voltaic." + key));
    }

    public static MutableComponent voltageTooltip(int voltage) {
        return VoltaicTextUtils.tooltip("machine.voltage", ChatFormatter.getChatDisplayShort(voltage, DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY);
    }

    public static MutableComponent ratio(Component numerator, Component denominator) {
        return numerator.m_6881_().m_130946_(" / ").m_7220_(denominator);
    }
}

