/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities.math;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import voltaic.prefab.utilities.object.Location;

public class MathUtils {
    public static final Vector3f XN = new Vector3f(-1.0f, 0.0f, 0.0f);
    public static final Vector3f XP = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f YN = new Vector3f(0.0f, -1.0f, 0.0f);
    public static final Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f ZN = new Vector3f(0.0f, 0.0f, -1.0f);
    public static final Vector3f ZP = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final CollisionContext EMPTY = new EntityCollisionContext(false, -1.7976931348623157E308, ItemStack.f_41583_, fluidState -> false, null){

        public boolean m_6513_(VoxelShape shape, BlockPos pos, boolean canAscend) {
            return canAscend;
        }
    };

    public static Location getRaytracedBlock(Entity entity) {
        return MathUtils.getRaytracedBlock(entity, 100.0);
    }

    public static Location getRaytracedBlock(Entity entity, double rayLength) {
        return MathUtils.getRaytracedBlock(entity.m_9236_(), entity.m_20154_(), entity.m_20299_(0.0f), rayLength);
    }

    public static Location getRaytracedBlock(Level world, Vec3 direction, Vec3 from, double rayLength) {
        Vec3 rayPath = direction.m_82541_().m_82490_(rayLength);
        Vec3 to = from.m_82549_(rayPath);
        ClipContext rayContext = new ClipContext(from, to, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, null);
        BlockHitResult rayHit = world.m_45547_(rayContext);
        return rayHit.m_6662_() != HitResult.Type.BLOCK ? null : new Location(rayHit.m_82425_());
    }

    public static int logBase2(int value) {
        return (int)(Math.log(value) / Math.log(2.0) + 1.0E-10);
    }

    public static int nearestPowerOf10(double value, boolean roundUp) {
        double power = Math.log10(value);
        if (roundUp) {
            return (int)Math.ceil(power);
        }
        return (int)Math.floor(power);
    }

    public static Quaternionf rotQuaternionRad(float angleX, float angleY, float angleZ) {
        float f = Mth.m_14031_((float)(0.5f * angleX));
        float f1 = Mth.m_14089_((float)(0.5f * angleX));
        float f2 = Mth.m_14031_((float)(0.5f * angleY));
        float f3 = Mth.m_14089_((float)(0.5f * angleY));
        float f4 = Mth.m_14031_((float)(0.5f * angleZ));
        float f5 = Mth.m_14089_((float)(0.5f * angleZ));
        float i = f * f3 * f5 + f1 * f2 * f4;
        float j = f1 * f2 * f5 - f * f3 * f4;
        float k = f * f2 * f5 + f1 * f3 * f4;
        float r = f1 * f3 * f5 - f * f2 * f4;
        return new Quaternionf(i, j, k, r);
    }

    public static Quaternionf rotQuaternionDeg(float angleX, float angleY, float angleZ) {
        return MathUtils.rotQuaternionRad(angleX / 180.0f * (float)Math.PI, angleY / 180.0f * (float)Math.PI, angleZ / 180.0f * (float)Math.PI);
    }

    public static Quaternionf rotVectorQuaternionRad(float angle, Vector3f vec) {
        return new Quaternionf().setAngleAxis(angle, vec.x(), vec.y(), vec.z());
    }

    public static Quaternionf rotVectorQuaternionDeg(float angle, Vector3f vec) {
        return MathUtils.rotVectorQuaternionRad(angle / 180.0f * (float)Math.PI, vec);
    }

    public static <T> T[] fillArr(T[] arr, T val) {
        Arrays.fill(arr, val);
        return arr;
    }
}

