/*
 * Decompiled with CFR 0.152.
 */
package crazywoddman.warium_ponder.jei;

import com.mojang.blaze3d.platform.InputConstants;
import crazywoddman.warium_ponder.jei.ReactorRecipes;
import crazywoddman.warium_ponder.jei.WariumJEI;
import crazywoddman.warium_ponder.jei.WariumPonderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;

public class ReactorCategory
implements IRecipeCategory<ReactorRecipes> {
    public static final RecipeType<ReactorRecipes> TYPE = RecipeType.create((String)"crusty_chunks", (String)"reactor", ReactorRecipes.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;

    private int ticks() {
        return (int)(System.currentTimeMillis() / 50L);
    }

    public ReactorCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 125);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumPonderUtil.getItem("breeder_reactor_interface"));
        this.slot = guiHelper.getSlotDrawable();
    }

    public RecipeType<ReactorRecipes> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Reactor");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ReactorRecipes recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addInputSlot(67, 1).addItemStack(recipe.getInput())).setBackground(this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addOutputSlot(67, 108).addItemStack(recipe.getOutput())).setBackground(this.slot, -1, -1);
    }

    public void draw(ReactorRecipes recipe, IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 16.0f, 0.0f);
        graphics.m_280168_().m_85841_(0.25f, 0.25f, 1.0f);
        graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"crusty_chunks", (String)("textures/jei/reactor_" + this.ticks() / 20 % 4 + ".png")), 0, 0, 0.0f, 0.0f, 600, 352, 600, 352);
        graphics.m_280168_().m_85849_();
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, "400s", 126, 117, 0x8B8B8B, false);
        for (int i = 0; i < 7; ++i) {
            int life = 20 + i * 3;
            int age = (this.ticks() + i * 7 + 74) % life;
            if (age > life) continue;
            Random rand = new Random((long)i * 14881488L + (long)(this.ticks() / life));
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(72.0f + (float)Math.cos(rand.nextFloat() * (float)Math.PI * 2.0f) * 5.0f + rand.nextFloat() * 5.0f, 35.0f + (float)Math.sin(rand.nextFloat() * (float)Math.PI * 2.0f) * 5.0f + rand.nextFloat() * 5.0f, 0.0f);
            graphics.m_280168_().m_85841_(0.6f - 0.6f * (float)age / (float)life, 0.6f - 0.6f * (float)age / (float)life, 1.0f);
            graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/particle/soul_fire_flame.png"), 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
            graphics.m_280168_().m_85849_();
        }
        int[] x = new int[]{40, 40, 104, 104};
        int[] y = new int[]{40, 20, 40, 20};
        for (int e = 0; e < 4; ++e) {
            for (int i = 0; i < 7; ++i) {
                int life = 20 + i * 3;
                int age = (this.ticks() + i * 7 + 57) % life;
                if (age > life) continue;
                Random rand = new Random((long)i * 14881488L + (long)e * 123L + (long)(this.ticks() / life));
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)x[e] + (float)Math.cos(rand.nextFloat() * (float)Math.PI * 2.0f) * 5.0f + rand.nextFloat() * 5.0f, (float)y[e] + (float)Math.sin(rand.nextFloat() * (float)Math.PI * 2.0f) * 5.0f + rand.nextFloat() * 5.0f, 0.0f);
                graphics.m_280168_().m_85841_(0.6f - 0.6f * (float)age / (float)life, 0.6f - 0.6f * (float)age / (float)life, 1.0f);
                graphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/particle/soul_fire_flame.png"), 0, 0, 0.0f, 0.0f, 8, 8, 8, 8);
                graphics.m_280168_().m_85849_();
            }
        }
        if (mouseX >= 64.0 && mouseX <= 86.0 && mouseY >= 35.0 && mouseY <= 41.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumPonderUtil.getItem("breeder_reactor_interface"), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 34.0 && mouseX <= 55.0 && mouseY >= 24.0 && mouseY <= 32.0 || mouseX >= 94.0 && mouseX <= 115.0 && mouseY >= 24.0 && mouseY <= 32.0 || mouseX >= 34.0 && mouseX <= 55.0 && mouseY >= 43.0 && mouseY <= 50.0 || mouseX >= 94.0 && mouseX <= 115.0 && mouseY >= 43.0 && mouseY <= 50.0) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.addAll(WariumPonderUtil.getItem("empty_fuel_rods").m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)));
            tooltip.add(1, Component.m_237113_((String)"Must contain at least 1 Uranium Fuel Rod").m_130940_(ChatFormatting.GOLD));
            graphics.m_280245_(Minecraft.m_91087_().f_91062_, tooltip.stream().map(Component::m_7532_).toList(), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 60.0 && mouseX <= 90.0 && mouseY >= 78.0 && mouseY <= 103.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumPonderUtil.getItem("breeder_reactor_port"), (int)mouseX, (int)mouseY);
        } else if (mouseX >= 15.0 && mouseX <= 32.0 && mouseY >= 33.0 && mouseY <= 43.0 || mouseX >= 117.0 && mouseX <= 134.0 && mouseY >= 33.0 && mouseY <= 43.0 || mouseX >= 25.0 && mouseX <= 64.0 && mouseY >= 23.0 && mouseY <= 36.0 || mouseX >= 85.0 && mouseX <= 125.0 && mouseY >= 23.0 && mouseY <= 36.0 || mouseX >= 25.0 && mouseX <= 64.0 && mouseY >= 41.0 && mouseY <= 53.0 || mouseX >= 85.0 && mouseX <= 125.0 && mouseY >= 41.0 && mouseY <= 53.0 || mouseX >= 15.0 && mouseX <= 29.0 && mouseY >= 51.0 && mouseY <= 96.0 || mouseX >= 120.0 && mouseX <= 134.0 && mouseY >= 51.0 && mouseY <= 96.0 || mouseX >= 60.0 && mouseX <= 89.0 && mouseY >= 54.0 && mouseY <= 97.0) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumPonderUtil.getItem("control_rod"), (int)mouseX, (int)mouseY);
        } else if (!(!(mouseX >= 0.0) || !(mouseX <= 152.0) || !(mouseY >= 16.0) || !(mouseY <= 101.0) || mouseX >= 0.0 && mouseX <= 22.0 && mouseY >= 16.0 && mouseY <= 22.0 || mouseX >= 128.0 && mouseX <= 150.0 && mouseY >= 16.0 && mouseY <= 22.0 || mouseX >= 0.0 && mouseX <= 22.0 && mouseY >= 95.0 && mouseY <= 101.0 || mouseX >= 128.0 && mouseX <= 150.0 && mouseY >= 95.0 && mouseY <= 101.0)) {
            graphics.m_280153_(Minecraft.m_91087_().f_91062_, WariumPonderUtil.getItem("reactor_casing"), (int)mouseX, (int)mouseY);
        }
    }

    public boolean handleInput(ReactorRecipes recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && input.m_84873_() == 0 && WariumJEI.jeiRuntime != null) {
            if (mouseX >= 64.0 && mouseX <= 86.0 && mouseY >= 35.0 && mouseY <= 41.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumPonderUtil.getItem("breeder_reactor_interface"))));
                return true;
            }
            if (mouseX >= 34.0 && mouseX <= 55.0 && mouseY >= 24.0 && mouseY <= 32.0 || mouseX >= 94.0 && mouseX <= 115.0 && mouseY >= 24.0 && mouseY <= 32.0 || mouseX >= 34.0 && mouseX <= 55.0 && mouseY >= 43.0 && mouseY <= 50.0 || mouseX >= 94.0 && mouseX <= 115.0 && mouseY >= 43.0 && mouseY <= 50.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumPonderUtil.getItem("empty_fuel_rods"))));
                return true;
            }
            if (mouseX >= 60.0 && mouseX <= 90.0 && mouseY >= 78.0 && mouseY <= 103.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumPonderUtil.getItem("breeder_reactor_port"))));
                return true;
            }
            if (mouseX >= 15.0 && mouseX <= 32.0 && mouseY >= 33.0 && mouseY <= 43.0 || mouseX >= 117.0 && mouseX <= 134.0 && mouseY >= 33.0 && mouseY <= 43.0 || mouseX >= 25.0 && mouseX <= 64.0 && mouseY >= 23.0 && mouseY <= 36.0 || mouseX >= 85.0 && mouseX <= 125.0 && mouseY >= 23.0 && mouseY <= 36.0 || mouseX >= 25.0 && mouseX <= 64.0 && mouseY >= 41.0 && mouseY <= 53.0 || mouseX >= 85.0 && mouseX <= 125.0 && mouseY >= 41.0 && mouseY <= 53.0 || mouseX >= 15.0 && mouseX <= 29.0 && mouseY >= 51.0 && mouseY <= 96.0 || mouseX >= 120.0 && mouseX <= 134.0 && mouseY >= 51.0 && mouseY <= 96.0 || mouseX >= 60.0 && mouseX <= 89.0 && mouseY >= 54.0 && mouseY <= 97.0) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumPonderUtil.getItem("control_rod"))));
                return true;
            }
            if (!(!(mouseX >= 0.0) || !(mouseX <= 152.0) || !(mouseY >= 16.0) || !(mouseY <= 101.0) || mouseX >= 0.0 && mouseX <= 22.0 && mouseY >= 16.0 && mouseY <= 22.0 || mouseX >= 128.0 && mouseX <= 150.0 && mouseY >= 16.0 && mouseY <= 22.0 || mouseX >= 0.0 && mouseX <= 22.0 && mouseY >= 95.0 && mouseY <= 101.0 || mouseX >= 128.0 && mouseX <= 150.0 && mouseY >= 95.0 && mouseY <= 101.0)) {
                WariumJEI.jeiRuntime.getRecipesGui().show(List.of(WariumJEI.jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)WariumPonderUtil.getItem("reactor_casing"))));
                return true;
            }
        }
        return false;
    }
}

