/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.items;

import java.util.List;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.entities.TickingLightEntity;
import mod.azure.azurelib.platform.Services;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class BaseGunItem
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache(this);
    private BlockPos lightBlockPos = null;

    protected BaseGunItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<BaseGunItem>(this, "shoot_controller", event -> PlayState.CONTINUE).triggerableAnim("firing", RawAnimation.begin().then("firing", Animation.LoopType.PLAY_ONCE)).triggerableAnim("reload", RawAnimation.begin().then("reload", Animation.LoopType.PLAY_ONCE)));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void removeAmmo(Item ammo, Player playerEntity) {
        if (!playerEntity.m_7500_()) {
            block0: for (ItemStack item : playerEntity.m_150109_().f_35976_) {
                if (item.m_41720_() == ammo) {
                    item.m_41774_(1);
                    break;
                }
                for (ItemStack item1 : playerEntity.m_150109_().f_35974_) {
                    if (item1.m_41720_() != ammo) continue;
                    item1.m_41774_(1);
                    continue block0;
                }
            }
        }
    }

    public void removeOffHandItem(Item ammo, Player playerEntity) {
        if (!playerEntity.m_7500_()) {
            for (ItemStack item : playerEntity.m_150109_().f_35976_) {
                if (item.m_41720_() != ammo) continue;
                item.m_41774_(1);
                break;
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.m_237115_((String)("Ammo: " + (stack.m_41776_() - stack.m_41773_() - 1) + " / " + (stack.m_41776_() - 1))).m_130940_(ChatFormatting.ITALIC));
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    protected void spawnLightSource(Entity entity, boolean isInWaterBlock) {
        if (this.lightBlockPos == null) {
            this.lightBlockPos = this.findFreeSpace(entity.m_9236_(), entity.m_20183_(), 2);
            if (this.lightBlockPos == null) {
                return;
            }
            entity.m_9236_().m_46597_(this.lightBlockPos, Services.PLATFORM.getTickingLightBlock().m_49966_());
        } else if (this.checkDistance(this.lightBlockPos, entity.m_20183_(), 2)) {
            BlockEntity blockEntity = entity.m_9236_().m_7702_(this.lightBlockPos);
            if (blockEntity instanceof TickingLightEntity) {
                TickingLightEntity tickingLightEntity = (TickingLightEntity)blockEntity;
                tickingLightEntity.refresh(isInWaterBlock ? 20 : 0);
            } else {
                this.lightBlockPos = null;
            }
        } else {
            this.lightBlockPos = null;
        }
    }

    private boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB, int distance) {
        return Math.abs(blockPosA.m_123341_() - blockPosB.m_123341_()) <= distance && Math.abs(blockPosA.m_123342_() - blockPosB.m_123342_()) <= distance && Math.abs(blockPosA.m_123343_() - blockPosB.m_123343_()) <= distance;
    }

    private BlockPos findFreeSpace(Level world, BlockPos blockPos, int maxDistance) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[maxDistance * 2 + 1];
        offsets[0] = 0;
        for (int i = 2; i <= maxDistance * 2; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(offsetPos);
                    if (!state.m_60795_() && !state.m_60734_().equals((Object)Services.PLATFORM.getTickingLightBlock())) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }

    public static EntityHitResult hitscanTrace(Player player, double range, float ticks) {
        Vec3 look = player.m_20252_(ticks);
        Vec3 start = player.m_20299_(ticks);
        Vec3 end = new Vec3(player.m_20185_() + look.f_82479_ * range, player.m_20188_() + look.f_82480_ * range, player.m_20189_() + look.f_82481_ * range);
        double traceDistance = player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_82450_().m_82557_(end);
        for (Entity possible : player.m_9236_().m_6249_((Entity)player, player.m_20191_().m_82369_(look.m_82490_(traceDistance)).m_82363_(3.0, 3.0, 3.0), entity -> !entity.m_5833_() && entity.m_6087_() && entity instanceof LivingEntity)) {
            if (!possible.m_20191_().m_82400_(0.3).m_82371_(start, end).isPresent() || !(start.m_82557_((Vec3)possible.m_20191_().m_82400_(0.3).m_82371_(start, end).get()) < traceDistance)) continue;
            return ProjectileUtil.m_37304_((Level)player.m_9236_(), (Entity)player, (Vec3)start, (Vec3)end, (AABB)player.m_20191_().m_82369_(look.m_82490_(traceDistance)).m_82377_(3.0, 3.0, 3.0), target -> !target.m_5833_() && player.m_6097_() && player.m_142582_(target));
        }
        return null;
    }
}

