/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.entity.AzEntityModelRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class AzDynamicEntityModelRenderer<T extends Entity>
extends AzEntityModelRenderer<T> {
    public AzDynamicEntityModelRenderer(AzEntityRendererPipeline<T> entityRendererPipeline, AzLayerRenderer<T> layerRenderer) {
        super(entityRendererPipeline, layerRenderer);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        VertexConsumer buffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        Entity entity = (Entity)context.animatable();
        PoseStack poseStack = context.poseStack();
        RenderType renderType = context.renderType();
        poseStack.m_85836_();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRendererPipeline.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.entityRendererPipeline.getRenderer().m_7860_(entity, 1.0f).m_252839_()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), entity.m_20182_().m_252839_()));
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        AzRendererConfig<Entity> config = this.entityRendererPipeline.config();
        context.setTextureOverride(this.getTextureOverrideForBone(bone, (Entity)context.animatable(), context.partialTick()));
        ResourceLocation texture = context.getTextureOverride() == null ? config.textureLocation((Entity)context.animatable()) : context.getTextureOverride();
        RenderType renderTypeOverride = this.getRenderTypeOverrideForBone(bone, (Entity)context.animatable(), texture, bufferSource, context.partialTick());
        if (texture != null && renderTypeOverride == null) {
            renderType = renderTypeOverride = context.getDefaultRenderType((Entity)context.animatable(), texture, context.multiBufferSource(), context.partialTick());
        }
        if (renderTypeOverride != null) {
            context.setVertexConsumer(bufferSource.m_6299_(renderTypeOverride));
            renderType = renderTypeOverride;
        }
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, context.partialTick(), context.packedLight(), context.packedOverlay(), context.red(), context.green(), context.blue(), context.alpha())) {
            super.renderCubesOfBone(context, bone);
        }
        if (!isReRender && buffer instanceof BufferBuilder) {
            BufferBuilder builder = (BufferBuilder)buffer;
            if (!builder.f_85661_) {
                context.setVertexConsumer(bufferSource.m_6299_(renderType));
            }
        }
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.m_85849_();
    }

    @Override
    protected void createVerticesOfQuad(AzRendererPipelineContext<T> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        if (context.getTextureOverride() == null) {
            super.createVerticesOfQuad(context, quad, poseState, normal);
            return;
        }
        AzRendererConfig<Entity> config = this.entityRendererPipeline.config();
        IntIntPair boneTextureSize = context.computeTextureSize(context.getTextureOverride());
        IntIntPair entityTextureSize = context.computeTextureSize(config.textureLocation((Entity)context.animatable()));
        if (boneTextureSize == null || entityTextureSize == null) {
            super.createVerticesOfQuad(context, quad, poseState, normal);
            return;
        }
        for (GeoVertex vertex : quad.vertices()) {
            Vector4f vector4f = poseState.transform(new Vector4f(vertex.position().x(), vertex.position().y(), vertex.position().z(), 1.0f));
            float texU = vertex.texU() * (float)entityTextureSize.firstInt() / (float)boneTextureSize.firstInt();
            float texV = vertex.texV() * (float)entityTextureSize.secondInt() / (float)boneTextureSize.secondInt();
            context.vertexConsumer().m_5954_(vector4f.x(), vector4f.y(), vector4f.z(), context.red(), context.green(), context.blue(), context.alpha(), texU, texV, context.packedOverlay(), context.packedLight(), normal.x(), normal.y(), normal.z());
        }
    }
}

