/*
 * Decompiled with CFR 0.152.
 */
package net.bullfighter.adastraextra.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class NeptuneRenderProcedure {
    private static RenderLevelStageEvent _provider = null;
    private static Runnable _fogRenderer = null;
    private static boolean _usingBuffers = false;
    private static VertexBuffer _abyssBuffer = null;
    private static VertexBuffer _deepskyBuffer = null;
    private static VertexBuffer _moonBuffer = null;
    private static VertexBuffer _polygonBuffer = null;
    private static VertexBuffer _shapeBuffer = null;
    private static VertexBuffer _skyboxBuffer = null;
    private static VertexBuffer _starBuffer = null;
    private static VertexBuffer _sunBuffer = null;
    private static VertexBuffer _sunlightBuffer = null;
    private static VertexBuffer _textureBuffer = null;
    private static BufferBuilder _bufferBuilder = null;

    private static void begin(int type) {
        if (_bufferBuilder == null) {
            _bufferBuilder = Tesselator.m_85913_().m_85915_();
            switch (type) {
                case 0: {
                    _bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                    break;
                }
                case 1: {
                    _bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
                    break;
                }
                case 2: {
                    _bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                    break;
                }
                case 3: {
                    _bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                    break;
                }
                case 4: {
                    _bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                    break;
                }
                case 5: {
                    _bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
                    break;
                }
                case 6: {
                    _bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
                }
            }
        }
    }

    private static void vertex(float yaw, float pitch, float radius, int color) {
        NeptuneRenderProcedure.vertex(yaw, pitch, radius, 0.0f, 0.0f, color);
    }

    private static void vertex(float yaw, float pitch, float radius, float u, float v, int color) {
        if (_bufferBuilder != null && _bufferBuilder.m_85732_()) {
            if (_bufferBuilder.m_6297_().m_86048_() == VertexFormatElement.Usage.POSITION) {
                float y = yaw * ((float)Math.PI / 180);
                float p = pitch * ((float)Math.PI / 180);
                float i = -Mth.m_14031_((float)y) * Mth.m_14089_((float)p) * radius;
                float j = -Mth.m_14031_((float)p) * radius;
                float k = Mth.m_14089_((float)y) * Mth.m_14089_((float)p) * radius;
                _bufferBuilder.m_5483_((double)i, (double)j, (double)k);
            }
            if (_bufferBuilder.m_6297_().m_86048_() == VertexFormatElement.Usage.UV) {
                _bufferBuilder.m_7421_(u, v);
            }
            if (_bufferBuilder.m_6297_().m_86048_() == VertexFormatElement.Usage.COLOR) {
                _bufferBuilder.m_193479_(color);
            }
            _bufferBuilder.m_5752_();
        }
    }

    private static void end() {
        if (_bufferBuilder != null && _bufferBuilder.m_85732_()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (_shapeBuffer != null) {
                _shapeBuffer.close();
            }
            _shapeBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            _shapeBuffer.m_85921_();
            _shapeBuffer.m_231221_(_bufferBuilder.m_231175_());
            if (_usingBuffers) {
                VertexBuffer.m_85931_();
            } else {
                ShaderInstance shaderInstance = null;
                if (_shapeBuffer.m_166892_() == DefaultVertexFormat.f_85815_) {
                    RenderSystem.setShader(GameRenderer::m_172811_);
                    shaderInstance = GameRenderer.m_172811_();
                } else if (_shapeBuffer.m_166892_() == DefaultVertexFormat.f_85819_) {
                    RenderSystem.setShader(GameRenderer::m_172820_);
                    shaderInstance = GameRenderer.m_172820_();
                }
                _shapeBuffer.m_253207_(_provider.getPoseStack().m_85850_().m_252922_(), _provider.getProjectionMatrix(), shaderInstance);
                _shapeBuffer.close();
            }
            _bufferBuilder = null;
        }
    }

    private static void renderAbyss(int color, boolean constant) {
        Minecraft minecraft = Minecraft.m_91087_();
        double h = minecraft.f_91074_.m_20299_(_provider.getPartialTick()).m_7098_() - minecraft.f_91073_.m_6106_().m_171687_((LevelHeightAccessor)minecraft.f_91073_);
        if (constant || h < 0.0) {
            PoseStack poseStack = _provider.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 12.0f, 0.0f);
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            RenderSystem.setShader(GameRenderer::m_172808_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
            bufferBuilder.m_5483_(0.0, -16.0, 0.0).m_193479_(color).m_5752_();
            for (int i = 0; i <= 8; ++i) {
                bufferBuilder.m_5483_((double)(-512.0f * Mth.m_14089_((float)((float)i * 45.0f * ((float)Math.PI / 180)))), -16.0, (double)(512.0f * Mth.m_14031_((float)((float)i * 45.0f * ((float)Math.PI / 180))))).m_5752_();
            }
            if (_abyssBuffer != null) {
                _abyssBuffer.close();
            }
            _abyssBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            _abyssBuffer.m_85921_();
            _abyssBuffer.m_231221_(bufferBuilder.m_231175_());
            if (_usingBuffers) {
                VertexBuffer.m_85931_();
            } else {
                _abyssBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172808_());
                _abyssBuffer.close();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    private static void renderBuffer(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, int color) {
        if (_usingBuffers && vertexBuffer != null) {
            PoseStack poseStack = _provider.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_85837_(x, y, z);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
            poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            vertexBuffer.m_85921_();
            ShaderInstance shaderInstance = GameRenderer.m_172808_();
            if (vertexBuffer.m_166892_() == DefaultVertexFormat.f_85815_) {
                shaderInstance = GameRenderer.m_172811_();
            } else if (vertexBuffer.m_166892_() == DefaultVertexFormat.f_85819_) {
                shaderInstance = GameRenderer.m_172820_();
            }
            vertexBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), shaderInstance);
            VertexBuffer.m_85931_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    private static void renderCorepolygon(int vertex, float size, float yaw, float pitch, float roll, int color, boolean constant) {
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.m_91087_().f_91073_.m_46722_(_provider.getPartialTick());
        }
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        float deg = 360.0f / (float)vertex;
        bufferBuilder.m_5483_(0.0, 0.0, 100.0).m_6122_(255, 255, 255, 255).m_5752_();
        for (int i = 0; i <= vertex; ++i) {
            bufferBuilder.m_5483_((double)(-size * Mth.m_14089_((float)((90.0f + (float)i * deg) * ((float)Math.PI / 180)))), (double)(size * Mth.m_14031_((float)((90.0f + (float)i * deg) * ((float)Math.PI / 180)))), 100.0).m_6122_(255, 255, 255, 0).m_5752_();
        }
        if (_polygonBuffer != null) {
            _polygonBuffer.close();
        }
        _polygonBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _polygonBuffer.m_85921_();
        _polygonBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _polygonBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172811_());
            _polygonBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderCrustpolygon(int vertex, float size, float yaw, float pitch, float roll, int color, boolean constant) {
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.m_91087_().f_91073_.m_46722_(_provider.getPartialTick());
        }
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        float deg = 360.0f / (float)vertex;
        bufferBuilder.m_5483_(0.0, 0.0, 100.0).m_6122_(255, 255, 255, 0).m_5752_();
        for (int i = 0; i <= vertex; ++i) {
            bufferBuilder.m_5483_((double)(-size * Mth.m_14089_((float)((90.0f + (float)i * deg) * ((float)Math.PI / 180)))), (double)(size * Mth.m_14031_((float)((90.0f + (float)i * deg) * ((float)Math.PI / 180)))), 100.0).m_6122_(255, 255, 255, 255).m_5752_();
        }
        if (_polygonBuffer != null) {
            _polygonBuffer.close();
        }
        _polygonBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _polygonBuffer.m_85921_();
        _polygonBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _polygonBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172811_());
            _polygonBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderDeepsky(int color) {
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        RenderSystem.setShader(GameRenderer::m_172808_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_(0.0, 16.0, 0.0).m_193479_(color).m_5752_();
        for (int i = 0; i <= 8; ++i) {
            bufferBuilder.m_5483_((double)(512.0f * Mth.m_14089_((float)(45.0f * (float)i * ((float)Math.PI / 180)))), 16.0, (double)(512.0f * Mth.m_14031_((float)(45.0f * (float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        if (_deepskyBuffer != null) {
            _deepskyBuffer.close();
        }
        _deepskyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _deepskyBuffer.m_85921_();
        _deepskyBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _deepskyBuffer.m_253207_(_provider.getPoseStack().m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172808_());
            _deepskyBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderEndsky() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/end_sky.png"));
        RenderSystem.defaultBlendFunc();
        NeptuneRenderProcedure.renderEndsky(0.0f, 0.0f, 0.0f, -14145496);
    }

    private static void renderEndsky(float yaw, float pitch, float roll, int color) {
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        RenderSystem.setShader(GameRenderer::m_172820_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        block8: for (int i = 0; i < 6; ++i) {
            switch (i) {
                case 0: {
                    bufferBuilder.m_5483_(-100.0, -100.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, 100.0).m_7421_(0.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, 100.0).m_7421_(16.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, -100.0).m_7421_(16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 1: {
                    bufferBuilder.m_5483_(-100.0, -100.0, 100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, 100.0, 100.0).m_7421_(0.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, 100.0).m_7421_(16.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, 100.0).m_7421_(16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 2: {
                    bufferBuilder.m_5483_(-100.0, 100.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, -100.0).m_7421_(0.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, -100.0).m_7421_(16.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, -100.0).m_7421_(16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 3: {
                    bufferBuilder.m_5483_(-100.0, 100.0, 100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, 100.0, -100.0).m_7421_(0.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, -100.0).m_7421_(16.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, 100.0).m_7421_(16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 4: {
                    bufferBuilder.m_5483_(-100.0, 100.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, 100.0, 100.0).m_7421_(0.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, 100.0).m_7421_(16.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, -100.0).m_7421_(16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 5: {
                    bufferBuilder.m_5483_(100.0, -100.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, 100.0).m_7421_(0.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, 100.0).m_7421_(16.0f, 16.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, -100.0).m_7421_(16.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                }
            }
        }
        if (_skyboxBuffer != null) {
            _skyboxBuffer.close();
        }
        _skyboxBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _skyboxBuffer.m_85921_();
        _skyboxBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _skyboxBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172820_());
            _skyboxBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderFlatpolygon(int vertex, float size, float yaw, float pitch, float roll, int color, boolean constant) {
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.m_91087_().f_91073_.m_46722_(_provider.getPartialTick());
        }
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        float deg = 360.0f / (float)vertex;
        bufferBuilder.m_5483_(0.0, 0.0, 100.0).m_6122_(255, 255, 255, 255).m_5752_();
        for (int i = 0; i <= vertex; ++i) {
            bufferBuilder.m_5483_((double)(-size * Mth.m_14089_((float)((90.0f + (float)i * deg) * ((float)Math.PI / 180)))), (double)(size * Mth.m_14031_((float)((90.0f + (float)i * deg) * ((float)Math.PI / 180)))), 100.0).m_6122_(255, 255, 255, 255).m_5752_();
        }
        if (_polygonBuffer != null) {
            _polygonBuffer.close();
        }
        _polygonBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _polygonBuffer.m_85921_();
        _polygonBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _polygonBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172811_());
            _polygonBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderLinepolygon(int vertex, float size, float yaw, float pitch, float roll, int color, boolean constant) {
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.m_91087_().f_91073_.m_46722_(_provider.getPartialTick());
        }
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        float deg = 360.0f / (float)vertex;
        for (int i = 0; i <= vertex; ++i) {
            bufferBuilder.m_5483_((double)(-size * Mth.m_14089_((float)((90.0f + (float)i * deg) * ((float)Math.PI / 180)))), (double)(size * Mth.m_14031_((float)((90.0f + (float)i * deg) * ((float)Math.PI / 180)))), 100.0).m_6122_(255, 255, 255, 255).m_5752_();
        }
        if (_polygonBuffer != null) {
            _polygonBuffer.close();
        }
        _polygonBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _polygonBuffer.m_85921_();
        _polygonBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _polygonBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172811_());
            _polygonBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderMoon(float size, float angle, int color, boolean phase, boolean constant) {
        float r = size / 2.0f;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        if (phase) {
            int i0 = Minecraft.m_91087_().f_91073_.m_46941_();
            int i1 = i0 % 4;
            int i2 = i0 / 4 % 2;
            u0 = (float)i1 / 4.0f;
            v0 = (float)i2 / 2.0f;
            u1 = (float)(i1 + 1) / 4.0f;
            v1 = (float)(i2 + 1) / 2.0f;
        }
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.m_91087_().f_91073_.m_46722_(_provider.getPartialTick());
        }
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(angle));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::m_172820_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_((double)(-r), -100.0, (double)(-r)).m_7421_(u1, v1).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)(-r), -100.0, (double)r).m_7421_(u0, v1).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)r, -100.0, (double)r).m_7421_(u0, v0).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)r, -100.0, (double)(-r)).m_7421_(u1, v0).m_6122_(255, 255, 255, 255).m_5752_();
        if (_moonBuffer != null) {
            _moonBuffer.close();
        }
        _moonBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _moonBuffer.m_85921_();
        _moonBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _moonBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172820_());
            _moonBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderOnefacesky(float yaw, float pitch, float roll, int color) {
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        RenderSystem.setShader(GameRenderer::m_172820_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        block8: for (int i = 0; i < 6; ++i) {
            switch (i) {
                case 0: {
                    bufferBuilder.m_5483_(-100.0, -100.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, 100.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, 100.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, -100.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 1: {
                    bufferBuilder.m_5483_(-100.0, 100.0, 100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, 100.0, -100.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, -100.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, 100.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 2: {
                    bufferBuilder.m_5483_(100.0, 100.0, 100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, 100.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, 100.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, 100.0, 100.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 3: {
                    bufferBuilder.m_5483_(-100.0, 100.0, 100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, 100.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, -100.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, 100.0, -100.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 4: {
                    bufferBuilder.m_5483_(-100.0, 100.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, -100.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, -100.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, -100.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 5: {
                    bufferBuilder.m_5483_(100.0, 100.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, -100.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, 100.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, 100.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                }
            }
        }
        if (_skyboxBuffer != null) {
            _skyboxBuffer.close();
        }
        _skyboxBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _skyboxBuffer.m_85921_();
        _skyboxBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _skyboxBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172820_());
            _skyboxBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderPolygon(int mode, int vertex, float size, float yaw, float pitch, float roll, int color, boolean constant) {
        if (vertex >= 2) {
            switch (mode) {
                case 0: {
                    NeptuneRenderProcedure.renderCorepolygon(vertex, size, yaw, pitch, roll, color, constant);
                    break;
                }
                case 1: {
                    NeptuneRenderProcedure.renderCrustpolygon(vertex, size, yaw, pitch, roll, color, constant);
                    break;
                }
                case 2: {
                    NeptuneRenderProcedure.renderFlatpolygon(vertex, size, yaw, pitch, roll, color, constant);
                    break;
                }
                case 3: {
                    NeptuneRenderProcedure.renderLinepolygon(vertex, size, yaw, pitch, roll, color, constant);
                }
            }
        }
    }

    private static void renderSixfacesky(float yaw, float pitch, float roll, int color) {
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        RenderSystem.setShader(GameRenderer::m_172820_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        block8: for (int i = 0; i < 6; ++i) {
            switch (i) {
                case 0: {
                    bufferBuilder.m_5483_(-100.0, -100.0, -100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, 100.0).m_7421_(0.0f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, 100.0).m_7421_(0.33333334f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, -100.0).m_7421_(0.33333334f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 1: {
                    bufferBuilder.m_5483_(-100.0, 100.0, 100.0).m_7421_(0.33333334f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, 100.0, -100.0).m_7421_(0.33333334f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, -100.0).m_7421_(0.6666667f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, 100.0).m_7421_(0.6666667f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 2: {
                    bufferBuilder.m_5483_(100.0, 100.0, 100.0).m_7421_(0.6666667f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, 100.0).m_7421_(0.6666667f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, 100.0).m_7421_(1.0f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, 100.0, 100.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 3: {
                    bufferBuilder.m_5483_(-100.0, 100.0, 100.0).m_7421_(0.0f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, 100.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, -100.0).m_7421_(0.33333334f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, 100.0, -100.0).m_7421_(0.33333334f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 4: {
                    bufferBuilder.m_5483_(-100.0, 100.0, -100.0).m_7421_(0.33333334f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(-100.0, -100.0, -100.0).m_7421_(0.33333334f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, -100.0).m_7421_(0.6666667f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, -100.0).m_7421_(0.6666667f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    continue block8;
                }
                case 5: {
                    bufferBuilder.m_5483_(100.0, 100.0, -100.0).m_7421_(0.6666667f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, -100.0).m_7421_(0.6666667f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, -100.0, 100.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
                    bufferBuilder.m_5483_(100.0, 100.0, 100.0).m_7421_(1.0f, 0.5f).m_6122_(255, 255, 255, 255).m_5752_();
                }
            }
        }
        if (_skyboxBuffer != null) {
            _skyboxBuffer.close();
        }
        _skyboxBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _skyboxBuffer.m_85921_();
        _skyboxBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _skyboxBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172820_());
            _skyboxBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderSky(boolean abyss, boolean deepsky, boolean moon, boolean stars, boolean sun, boolean sunlights) {
        Object color;
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        float partialTick = _provider.getPartialTick();
        if (deepsky) {
            color = level.m_171660_(minecraft.f_91063_.m_109153_().m_90583_(), partialTick);
            RenderSystem.defaultBlendFunc();
            NeptuneRenderProcedure.renderDeepsky(0xFF000000 | (int)(color.m_7096_() * 255.0) << 16 | (int)(color.m_7098_() * 255.0) << 8 | (int)(color.m_7094_() * 255.0));
        }
        if (sunlights && (color = (Object)level.m_104583_().m_7518_(level.m_46942_(partialTick), partialTick)) != null) {
            RenderSystem.defaultBlendFunc();
            NeptuneRenderProcedure.renderSunlights((int)(color[3] * 255.0f) << 24 | (int)(color[0] * 255.0f) << 16 | (int)(color[1] * 255.0f) << 8 | (int)(color[2] * 255.0f));
        }
        if (sun) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/sun.png"));
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            NeptuneRenderProcedure.renderSun(60.0f, level.m_46942_(partialTick) * 360.0f, -1, false);
        }
        if (moon) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/moon_phases.png"));
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            NeptuneRenderProcedure.renderMoon(40.0f, level.m_46942_(partialTick) * 360.0f, -1, true, false);
        }
        if (stars) {
            int color2 = (int)(level.m_104811_(partialTick) * 255.0f);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            NeptuneRenderProcedure.renderStars(1500, 10842, 90.0f, level.m_46942_(partialTick) * 360.0f, 0.0f, color2 << 24 | color2 << 16 | color2 << 8 | color2, false);
        }
        if (abyss) {
            RenderSystem.defaultBlendFunc();
            NeptuneRenderProcedure.renderAbyss(-16777216, false);
        }
        RenderSystem.defaultBlendFunc();
    }

    private static void renderSkybox(int mode, float yaw, float pitch, float roll, int color, boolean constant) {
        boolean visible;
        Vec3 camPos = _provider.getCamera().m_90583_();
        boolean bl = visible = constant || !Minecraft.m_91087_().f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)camPos.m_7096_()), Mth.m_14107_((double)camPos.m_7098_())) && !Minecraft.m_91087_().f_91065_.m_93090_().m_93715_();
        if (visible) {
            switch (mode) {
                case 0: {
                    NeptuneRenderProcedure.renderEndsky(yaw, pitch, roll, color);
                    break;
                }
                case 1: {
                    NeptuneRenderProcedure.renderOnefacesky(yaw, pitch, roll, color);
                    break;
                }
                case 2: {
                    NeptuneRenderProcedure.renderSixfacesky(yaw, pitch, roll, color);
                }
            }
        }
    }

    private static void renderStars(int amount, int seed, float yaw, float pitch, float roll, int color, boolean constant) {
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.m_91087_().f_91073_.m_46722_(_provider.getPartialTick());
        }
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RandomSource randomsource = RandomSource.m_216335_((long)seed);
        for (int i = 0; i < 1500; ++i) {
            float f0 = randomsource.m_188501_() * 2.0f - 1.0f;
            float f1 = randomsource.m_188501_() * 2.0f - 1.0f;
            float f2 = randomsource.m_188501_() * 2.0f - 1.0f;
            float f3 = 0.15f + 0.1f * randomsource.m_188501_();
            float f4 = f0 * f0 + f1 * f1 + f2 * f2;
            if (!(f4 < 1.0f) || !(f4 > 0.01f)) continue;
            f4 = 1.0f / Mth.m_14116_((float)f4);
            float f5 = (f0 *= f4) * 100.0f;
            float f6 = (f1 *= f4) * 100.0f;
            float f7 = (f2 *= f4) * 100.0f;
            float f8 = (float)Math.atan2(f0, f2);
            float f9 = Mth.m_14031_((float)f8);
            float f10 = Mth.m_14089_((float)f8);
            float f11 = (float)Math.atan2(Mth.m_14116_((float)(f0 * f0 + f2 * f2)), f1);
            float f12 = Mth.m_14031_((float)f11);
            float f13 = Mth.m_14089_((float)f11);
            float f14 = (float)randomsource.m_188500_() * (float)Math.PI * 2.0f;
            float f15 = Mth.m_14031_((float)f14);
            float f16 = Mth.m_14089_((float)f14);
            for (int j = 0; j < 4; ++j) {
                float f17 = (float)((j & 2) - 1) * f3;
                float f18 = (float)((j + 1 & 2) - 1) * f3;
                float f20 = f17 * f16 - f18 * f15;
                float f21 = f18 * f16 + f17 * f15;
                float f22 = -f20 * f13;
                float f23 = f22 * f9 - f21 * f10;
                float f24 = f20 * f12;
                float f25 = f21 * f9 + f22 * f10;
                bufferBuilder.m_5483_((double)(f5 + f23), (double)(f6 + f24), (double)(f7 + f25)).m_6122_(255, 255, 255, 255).m_5752_();
            }
        }
        if (_starBuffer != null) {
            _starBuffer.close();
        }
        _starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _starBuffer.m_85921_();
        _starBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _starBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172811_());
            _starBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderSun(float size, float angle, int color, boolean constant) {
        float r = size / 2.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.m_91087_().f_91073_.m_46722_(_provider.getPartialTick());
        }
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(angle));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::m_172820_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_((double)r, 100.0, (double)(-r)).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)r, 100.0, (double)r).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)(-r), 100.0, (double)r).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)(-r), 100.0, (double)(-r)).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        if (_sunBuffer != null) {
            _sunBuffer.close();
        }
        _sunBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _sunBuffer.m_85921_();
        _sunBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _sunBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172820_());
            _sunBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderSunlights(int color) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float partialTick = _provider.getPartialTick();
        float[] base = level.m_104583_().m_7518_(level.m_46942_(partialTick), partialTick);
        if (base != null) {
            boolean flag;
            RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
            RenderSystem.setShader(GameRenderer::m_172811_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            boolean bl = flag = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f;
            if (flag || _usingBuffers) {
                bufferBuilder.m_5483_(100.0, 0.0, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
            } else {
                bufferBuilder.m_5483_(-100.0, 0.0, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
            }
            for (int i = 0; i <= 16; ++i) {
                float deg = (float)i * ((float)Math.PI * 2) / 16.0f;
                float sin = Mth.m_14031_((float)deg);
                float cos = Mth.m_14089_((float)deg);
                if (flag || _usingBuffers) {
                    bufferBuilder.m_5483_((double)(cos * 120.0f), (double)(cos * 40.0f * base[3]), (double)(-sin * 120.0f)).m_6122_(255, 255, 255, 0).m_5752_();
                    continue;
                }
                bufferBuilder.m_5483_((double)(-cos * 120.0f), (double)(cos * 40.0f * base[3]), (double)(sin * 120.0f)).m_6122_(255, 255, 255, 0).m_5752_();
            }
            if (_sunlightBuffer != null) {
                _sunlightBuffer.close();
            }
            _sunlightBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            _sunlightBuffer.m_85921_();
            _sunlightBuffer.m_231221_(bufferBuilder.m_231175_());
            if (_usingBuffers) {
                VertexBuffer.m_85931_();
            } else {
                _sunlightBuffer.m_253207_(_provider.getPoseStack().m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172811_());
                _sunlightBuffer.close();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static void renderTexture(float size, float yaw, float pitch, float roll, int color, boolean constant) {
        float r = size / 2.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - Minecraft.m_91087_().f_91073_.m_46722_(_provider.getPartialTick());
        }
        PoseStack poseStack = _provider.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::m_172820_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_((double)r, (double)r, 100.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)r, (double)(-r), 100.0).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)(-r), (double)(-r), 100.0).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)(-r), (double)r, 100.0).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        if (_textureBuffer != null) {
            _textureBuffer.close();
        }
        _textureBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        _textureBuffer.m_85921_();
        _textureBuffer.m_231221_(bufferBuilder.m_231175_());
        if (_usingBuffers) {
            VertexBuffer.m_85931_();
        } else {
            _textureBuffer.m_253207_(poseStack.m_85850_().m_252922_(), _provider.getProjectionMatrix(), GameRenderer.m_172820_());
            _textureBuffer.close();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderSky(RenderLevelStageEvent event) {
        _provider = event;
        if (_provider.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            Entity entity = _provider.getCamera().m_90592_();
            Vec3 camPos = _provider.getCamera().m_90583_();
            Vec3 entPos = entity.m_20318_(_provider.getPartialTick());
            boolean isFoggy = level.m_104583_().m_5781_(Mth.m_14107_((double)camPos.m_7096_()), Mth.m_14107_((double)camPos.m_7098_())) || minecraft.f_91065_.m_93090_().m_93715_();
            _fogRenderer = () -> FogRenderer.m_234172_((Camera)_provider.getCamera(), (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)minecraft.f_91063_.m_109152_(), (boolean)isFoggy, (float)_provider.getPartialTick());
            _fogRenderer.run();
            FogRenderer.m_109036_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            NeptuneRenderProcedure.execute((Event)_provider, (LevelAccessor)level, (ResourceKey<Level>)level.m_46472_());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            _fogRenderer.run();
        }
    }

    public static void execute(LevelAccessor world, ResourceKey<Level> dimension) {
        NeptuneRenderProcedure.execute(null, world, dimension);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, ResourceKey<Level> dimension) {
        if (dimension == null) {
            return;
        }
        if (dimension == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("adastraextra:neptune"))) {
            RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
            NeptuneRenderProcedure.renderStars(3000, 10842, 90.0f, world.m_46942_(Minecraft.m_91087_().getPartialTick()) * 360.0f, 0.0f, -1, false);
            ResourceLocation _texturelocation = new ResourceLocation("adastraextra:textures/sky/sun.png");
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)_texturelocation);
            Minecraft.m_91087_().m_91097_().m_174784_(_texturelocation);
            NeptuneRenderProcedure.renderSun(10.0f, world.m_46942_(Minecraft.m_91087_().getPartialTick()) * 360.0f, -1, false);
        }
    }
}

