/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.transform.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.transform.IIngredientTransformer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.TransformReplaceSerializer;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.ingredient.transform.type.TransformReplace")
@Document(value="vanilla/api/ingredient/transform/type/TransformReplace")
public class TransformReplace<T extends IIngredient>
implements IIngredientTransformer<T> {
    private final IItemStack replaceWith;

    public TransformReplace(IItemStack replaceWith) {
        this.replaceWith = replaceWith;
    }

    @Override
    public IItemStack transform(IItemStack stack) {
        return IItemStack.of(this.replaceWith.getImmutableInternal());
    }

    @Override
    public String getCommandString(T transformedIngredient) {
        return String.format("%s.transformReplace(%s)", transformedIngredient.getCommandString(), this.replaceWith.getCommandString());
    }

    @Override
    public IIngredientTransformerSerializer getSerializer() {
        return TransformReplaceSerializer.INSTANCE;
    }

    public IItemStack getReplaceWith() {
        return this.replaceWith;
    }
}

