#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "nrf24.hpp"
#include "esp_log.h"
#include <cstdio>
#include <cstring>

static const char* TAG = "RX_MAIN";

extern "C" void app_main() {
    NRF24 radio(SPI2_HOST, GPIO_NUM_17, GPIO_NUM_5);
    
    ESP_LOGI(TAG, "RX start...");
    radio.begin();
    radio.startRX();

    uint8_t buf[33]; // 32 dane + 1 null terminator
    
    while(true) {
        if(radio.available()) {
            memset(buf, 0, 33); // czyszczenie
            radio.read(buf);
            ESP_LOGI(TAG, "receiver: %s", (char*)buf);
        }
        vTaskDelay(pdMS_TO_TICKS(10));
    }
}