#include "freertos/FreeRTOS.h"  //do rtosa
#include "freertos/task.h"
#include "nrf24.hpp"
#include "esp_log.h"
#include <cstring>
#include <cstdio>

static const char* TAG = "TX_MAIN";

extern "C" void app_main() {    //extern C jest dla c
    NRF24 radio(SPI2_HOST, GPIO_NUM_17, GPIO_NUM_5);
    
    ESP_LOGI(TAG, "TX start");
    radio.begin();

    const char* text = "standby";   //wskaznik na stendbaja
    uint8_t msg[32];    // 32 znaki
    memset(msg, 0, 32);
    memcpy(msg, text, strlen(text));    //usuwa smieci

    int counter = 0;

    while(true) {
        msg[30] = (uint8_t)('0' + (counter % 10)); 
        msg[31] = 0;    //0 jest koneic

        if (radio.send(msg)) {
            ESP_LOGI(TAG, "sent OK: %s", (char*)msg);
        } else {
            ESP_LOGW(TAG, "error");
        }

        counter++;
        vTaskDelay(pdMS_TO_TICKS(1000));
    }
}