#pragma once
#include "driver/spi_master.h"
#include "driver/gpio.h"
#include <cstdint>

class NRF24 {
public:
    NRF24(spi_host_device_t host, gpio_num_t ce, gpio_num_t csn);

    void begin();
    bool send(const uint8_t* data);
    void startRX();
    bool available();
    void read(uint8_t* data);

private:
    spi_device_handle_t spi;
    gpio_num_t ce_pin;
    spi_host_device_t spi_host;

    void ce(bool v);
    void writeReg(uint8_t reg, uint8_t val);
    uint8_t readReg(uint8_t reg);
    void writeBuf(uint8_t cmd, const uint8_t* buf, uint8_t len);
    void readBuf(uint8_t cmd, uint8_t* buf, uint8_t len);
};